/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.client;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.netty.channel.socket.SocketChannel;
import java.util.Map;
import jayeson.lib.delivery.api.IClient;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.IRouter;
import jayeson.lib.delivery.api.ITransport;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.api.messages.IPreParsingHook;
import jayeson.lib.delivery.core.AbstractEndPointMonitor;
import jayeson.lib.delivery.core.EndPoint;
import jayeson.lib.delivery.core.EndPointFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientEndPointMonitor
extends AbstractEndPointMonitor
implements NamedHandler {
    private static Logger log = LoggerFactory.getLogger(ClientEndPointMonitor.class);
    private IRouter router;
    private ITransport transport;
    private IClient client;
    @Inject
    private EndPointFactory endPointFactory;

    @Inject
    public ClientEndPointMonitor(@Assisted IClient client, @Assisted IRouter router, @Assisted ITransport transport) {
        this.router = router;
        this.transport = transport;
        this.client = client;
    }

    @Override
    public IEndPoint create(SocketChannel channel) {
        EndPoint ep = this.endPointFactory.create(channel, this.router, this.transport);
        Map<IMessageGroup, IMessageGroupProcessor> registeredGroups = this.client.getRegisteredMessageGroups();
        for (IMessageGroup key : registeredGroups.keySet()) {
            ep.registerGroupProcessor(key, registeredGroups.get(key));
        }
        Map<IMessageGroup, IPreParsingHook> registeredPreParsingHooks = this.client.getRegisteredPreParsingHooks();
        for (IMessageGroup key : registeredPreParsingHooks.keySet()) {
            ep.registerPreParsingHook(key, registeredPreParsingHooks.get(key));
        }
        return ep;
    }

    public IClient getClient() {
        return this.client;
    }

    @Override
    public String getName() {
        return "CLIENT_ENDPOINT_MONITOR";
    }
}

