/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.client;

import com.google.inject.Inject;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import jayeson.lib.delivery.api.ClientConfig;
import jayeson.lib.delivery.api.IClient;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.IEndPointListener;
import jayeson.lib.delivery.api.IRouter;
import jayeson.lib.delivery.api.ITransport;
import jayeson.lib.delivery.api.events.EPConnectedEvent;
import jayeson.lib.delivery.api.events.EPEvent;
import jayeson.lib.delivery.api.events.IEPEventDispatcher;
import jayeson.lib.delivery.api.exceptions.DeliveryExceptionHandler;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.api.messages.IPreParsingHook;
import jayeson.lib.delivery.core.CoreComponentFactory;
import jayeson.lib.delivery.core.EndPoint;
import jayeson.lib.delivery.core.client.ClientEndPointMonitor;
import jayeson.lib.delivery.core.client.ClientEndPointMonitorFactory;
import jayeson.lib.delivery.core.client.NettyBaseClient;
import jayeson.lib.delivery.core.keepalive.KeepAliveConstants;
import jayeson.lib.delivery.core.keepalive.KeepAliveGroupPreParsingHook;
import jayeson.lib.delivery.core.keepalive.KeepAliveMessageGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClient
extends NettyBaseClient
implements IClient,
IEndPointListener {
    private static Logger log = LoggerFactory.getLogger(DefaultClient.class);
    private ITransport transport;
    private IRouter router;
    public CoreComponentFactory ccFactory;
    private IEPEventDispatcher eventDispatcher;
    private Map<IMessageGroup, IMessageGroupProcessor> registeredMessageGroups = new HashMap<IMessageGroup, IMessageGroupProcessor>();
    private Map<IMessageGroup, IPreParsingHook> registeredPreParsingHooks = new HashMap<IMessageGroup, IPreParsingHook>();
    ClientEndPointMonitorFactory CEPMF;
    private boolean keepAlive;
    private IEndPoint endpoint;
    private CompletableFuture<EndPoint> connectionFuture;
    private DeliveryExceptionHandler exceptionHandler;

    @Inject
    public DefaultClient(ClientConfig clientConfig, ClientEndPointMonitorFactory CEPMF) {
        super(clientConfig);
        this.CEPMF = CEPMF;
        this.keepAlive = true;
    }

    @Override
    public void onEvent(EPEvent event) {
        if (event instanceof EPConnectedEvent) {
            this._handle((EPConnectedEvent)event);
        }
        this.eventDispatcher.dispatchEvent(event);
    }

    private void _handle(EPConnectedEvent event) {
        this.endpoint = event.getEndpoint();
        this.setupKeepAlive(this.endpoint);
        this.connectionFuture.complete((EndPoint)this.endpoint);
    }

    private void setupKeepAlive(IEndPoint ep) {
        ep.setState(KeepAliveConstants.ATTR_KEEP_ALIVE, this.keepAlive);
        Integer i = (int)this.clientConfig.getKeepAliveInterval();
        ep.setState(KeepAliveConstants.ATTR_KEEP_ALIVE_INTERVAL, i);
    }

    @Override
    public IClient connect() {
        DefaultClient returnObj = null;
        try {
            log.info("Starting client");
            this.connectionFuture = new CompletableFuture();
            super.connectNettyClient();
            this.connectionFuture.get();
            returnObj = this;
        }
        catch (Exception e) {
            log.error("Error while connecting to client", (Throwable)e);
            returnObj = null;
        }
        return returnObj;
    }

    @Override
    public void disconnect() {
        try {
            log.trace("Disconnecting Client");
            super.disconnectNettyClient();
        }
        catch (Exception e) {
            log.error("Error while disconnecting client", (Throwable)e);
        }
    }

    @Override
    public ClientConfig configuration() {
        return this.clientConfig;
    }

    @Override
    public IClient setInitialTransport(ITransport transport) {
        this.transport = transport;
        return this;
    }

    @Override
    public IClient setInitialRouter(IRouter router) {
        this.router = router;
        return this;
    }

    @Override
    public void attachListener(IEndPointListener listner) {
        this.eventDispatcher.registerListener(listner);
    }

    @Override
    public void detachListener(IEndPointListener listener) {
        this.eventDispatcher.deregisterListener(listener);
    }

    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        IRouter router = this.ccFactory.createRouter((Channel)ch);
        ITransport transport = this.ccFactory.createTransport((Channel)ch);
        this.setupChannel(ch, router, transport);
    }

    protected void setupChannel(SocketChannel ch, IRouter router, ITransport transport) {
        ChannelPipeline channelPipeline = ch.pipeline();
        this.socketChannel = ch;
        ClientEndPointMonitor clientEndPointMonitor = this.CEPMF.create(this, router, transport);
        clientEndPointMonitor.setListener(this);
        channelPipeline.addLast(new ChannelHandler[]{clientEndPointMonitor});
    }

    @Override
    public IClient registerMessageGroup(IMessageGroup group, IMessageGroupProcessor messageGroupProcessor) {
        this.registeredMessageGroups.put(group, messageGroupProcessor);
        return this;
    }

    @Override
    public Map<IMessageGroup, IMessageGroupProcessor> getRegisteredMessageGroups() {
        HashMap<IMessageGroup, IMessageGroupProcessor> returnMap = new HashMap<IMessageGroup, IMessageGroupProcessor>();
        returnMap.putAll(this.registeredMessageGroups);
        return returnMap;
    }

    public IEPEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    @Inject
    public void setEventDispatcher(IEPEventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public IClient registerPreParsingHook(IMessageGroup group, IPreParsingHook preParsingHook) {
        this.registeredPreParsingHooks.put(group, preParsingHook);
        return this;
    }

    @Override
    public Map<IMessageGroup, IPreParsingHook> getRegisteredPreParsingHooks() {
        HashMap<IMessageGroup, IPreParsingHook> returnMap = new HashMap<IMessageGroup, IPreParsingHook>();
        returnMap.putAll(this.registeredPreParsingHooks);
        return returnMap;
    }

    @Override
    public IClient setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    @Override
    public IEndPoint getEndPoint() {
        return this.endpoint;
    }

    @Inject
    private void _kaPreParsingHook(KeepAliveMessageGroup grp, KeepAliveGroupPreParsingHook hook) {
        this.registerPreParsingHook(grp, hook);
    }

    @Inject
    public void setCCFactory(CoreComponentFactory ccFactory) {
        this.ccFactory = ccFactory;
    }

    @Override
    public boolean isKeepAlive() {
        return this.keepAlive;
    }
}

