/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;
import jayeson.lib.delivery.api.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NettyBaseClient
extends ChannelInitializer<SocketChannel> {
    private static Logger log = LoggerFactory.getLogger(NettyBaseClient.class);
    protected ClientConfig clientConfig;
    private ChannelHandler defaultChannelListener;
    protected SocketChannel socketChannel;
    protected EventLoopGroup workerGroup;
    private Channel upstreamChannel;

    public NettyBaseClient(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline channelPipeline = ch.pipeline();
        this.socketChannel = ch;
        if (this.defaultChannelListener == null) {
            log.error("No default channelHandler to add. Closing Channel");
            ch.close();
        } else {
            channelPipeline.addLast(new ChannelHandler[]{this.defaultChannelListener});
            log.info("Added Channel listener {}", this.defaultChannelListener.getClass());
        }
    }

    protected void connectNettyClient() throws InterruptedException {
        if (this.workerGroup == null || this.workerGroup.isShutdown() || this.workerGroup.isShuttingDown()) {
            this.workerGroup = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory("delivery-client-nioEventLoopGroup"));
        }
        Bootstrap clientBootStrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)clientBootStrap.group(this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)this);
        ChannelFuture channelFuture = clientBootStrap.connect(this.clientConfig.getHost(), this.clientConfig.getPort());
        this.upstreamChannel = channelFuture.channel();
        channelFuture.sync();
    }

    protected void shutDownWorkerGroup() {
        if (this.workerGroup != null) {
            try {
                this.workerGroup.shutdownGracefully();
            }
            catch (Exception e) {
                log.error("Exception while shutting down client worker group", (Throwable)e);
            }
        }
    }

    protected void disconnectNettyClient() throws InterruptedException {
        if (this.socketChannel != null && this.socketChannel.remoteAddress() != null) {
            log.debug("Closing NettyClient connected to {}:{}", (Object)this.socketChannel.remoteAddress().getHostString(), (Object)this.socketChannel.remoteAddress().getPort());
            this.socketChannel.flush();
            this.socketChannel.disconnect().sync();
            this.socketChannel.close().sync();
        }
        if (this.upstreamChannel != null) {
            this.upstreamChannel.close();
        }
        this.shutDownWorkerGroup();
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public ChannelHandler getDefaultChannelListener() {
        return this.defaultChannelListener;
    }

    public void setDefaultChannelListener(ChannelHandler defaultChannelListener) {
        this.defaultChannelListener = defaultChannelListener;
    }
}

