/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.http.messages;

import java.util.HashMap;
import java.util.Map;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.delivery.api.messages.MessageWrapper;

public class HttpMessageWrapper
extends MessageWrapper {
    private Map<String, String> headers = new HashMap<String, String>();
    private int status = -1;

    public HttpMessageWrapper(Object msg, IMessageClass<?> msgCls) {
        super(msg, msgCls);
    }

    public HttpMessageWrapper withHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HttpMessageWrapper withHeader(Map<String, String> hs) {
        this.headers.clear();
        this.headers.putAll(hs);
        return this;
    }

    public HttpMessageWrapper contentType(String type) {
        this.withHeader("Content-Type", type);
        return this;
    }

    public HttpMessageWrapper status(int status) {
        this.status = status;
        return this;
    }

    public boolean hasStatus() {
        return this.status != -1;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public int status() {
        return this.status;
    }
}

