/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.keepalive;

import javax.inject.Inject;
import javax.inject.Singleton;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IPreParsingHook;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.keepalive.KeepAliveMessageGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KeepAliveGroupPreParsingHook
implements IPreParsingHook {
    private static Logger log = LoggerFactory.getLogger(KeepAliveGroupPreParsingHook.class);
    private KeepAliveMessageGroup msgGroup;

    @Override
    public void onRegistered(IEndPoint endpoint) {
        log.info("KeepAlive - Group PreParsingHook registered to {}", (Object)endpoint.getIdentifier());
    }

    @Override
    public IMessageGroup messageGroup() {
        return this.msgGroup;
    }

    @Override
    public boolean processUnParsedMessage(MessageWrapper mw) {
        if (mw.getMessageClass() == this.msgGroup.MSG) {
            log.info("KeepAlive - The endpoint received keep-alive message From {}", (Object)mw.getEndpoint().getIdentifier());
            return false;
        }
        return true;
    }

    @Override
    public void onDeregistered(IEndPoint endpoint) {
        log.info("KeepAlive - Group PreParsingHook unregistered from {}", (Object)endpoint.getIdentifier());
    }

    @Inject
    public void messageGroup(KeepAliveMessageGroup grp) {
        this.msgGroup = grp;
    }
}

