/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.messages;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.string.StringDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.core.messages.BaseMessageClass;

public class StringMessageClass
extends BaseMessageClass<String> {
    private StringDecoder inH = new StringDecoder(Charset.forName("UTF-8"));
    private OutHandler outH = new OutHandler();

    public StringMessageClass(IMessageGroup group, byte id) {
        super(String.class, group, id);
    }

    @Override
    public List<ChannelHandler> inboundHandlers(Channel c) {
        return Arrays.asList(this.inH);
    }

    @Override
    public List<ChannelHandler> outboundHandlers(Channel c) {
        return Arrays.asList(new ChannelHandler[]{this.outH});
    }

    @ChannelHandler.Sharable
    private class OutHandler
    extends ChannelOutboundHandlerAdapter {
        private OutHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            byte[] arr = msg.toString().getBytes();
            ByteBuf buf = ctx.alloc().buffer(arr.length);
            buf.writeBytes(arr);
            ctx.write((Object)buf, promise);
        }
    }
}

