/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.ssl;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.List;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.core.ssl.SecureHandler;
import jayeson.lib.delivery.core.ssl.SecureHandlerFactory;
import jayeson.lib.delivery.core.tcp.TCPTransport;

public class SSLTransport
extends TCPTransport {
    protected SecureHandler secureHandler;

    @Inject
    public SSLTransport(@Assisted Channel channel, SecureHandlerFactory shFactory) {
        this.secureHandler = shFactory.create(channel.alloc());
    }

    @Override
    public List<NamedHandler> getDefaultHandlers() {
        ArrayList<NamedHandler> returnList = new ArrayList<NamedHandler>();
        returnList.add(this.secureHandler);
        returnList.add(this.dataFlusher);
        returnList.add(this.lengthEncoder);
        returnList.add(this.lengthDecoder);
        returnList.add(this.idleStateNotifier);
        returnList.add(this.idleStateListener);
        return returnList;
    }

    public SecureHandler getSecureHandler() {
        return this.secureHandler;
    }

    public void setSecureHandler(SecureHandler secureHandler) {
        this.secureHandler = secureHandler;
    }
}

