/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.ssl;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.TrustManagerFactory;
import jayeson.lib.delivery.api.SslConfig;
import jayeson.lib.delivery.core.client.DefaultClientModule;
import jayeson.lib.delivery.core.ssl.SecureHandlerFactory;
import jayeson.lib.delivery.core.ssl.SecureHandlerFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureClientModule
extends DefaultClientModule {
    private static Logger log = LoggerFactory.getLogger(SecureClientModule.class);
    private SslConfig sslConfig;

    public SecureClientModule(SslConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    @Override
    public void configure() {
        super.configure();
        SslContext sslContext = null;
        if (this.sslConfig.getTrustStore() != null) {
            try {
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                FileInputStream fis = new FileInputStream(this.sslConfig.getTrustStore());
                ks.load(fis, this.sslConfig.getTrustStorePassword().toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ks);
                fis.close();
                sslContext = SslContext.newClientContext((TrustManagerFactory)tmf);
            }
            catch (Exception ex) {
                log.warn("Error setting up truststore ", (Throwable)ex);
            }
        }
        if (sslContext == null) {
            sslContext = this.getSelfSignedCertContext();
        }
        if (sslContext != null) {
            this.bind(SslContext.class).toInstance((Object)sslContext);
            this.bind(SecureHandlerFactory.class).to(SecureHandlerFactoryImpl.class);
        }
    }

    public SslContext getSelfSignedCertContext() {
        try {
            if (this.sslConfig.isEnableSelfSignedCert()) {
                log.info("Setting up InsecureTrustManagerFactory as accept SelfSignedCertificate is enabled");
                return SslContext.newClientContext((TrustManagerFactory)InsecureTrustManagerFactory.INSTANCE);
            }
        }
        catch (Exception e) {
            log.error("FATAL: Error while setting up client Ssl Context with self signed certificates ", (Throwable)e);
        }
        return null;
    }
}

