/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.tcp;

import com.google.inject.Inject;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.core.keepalive.IdleStateNotifier;
import jayeson.lib.delivery.core.keepalive.KeepAliveConstants;
import jayeson.lib.delivery.core.tcp.AbstractTransport;
import jayeson.lib.delivery.core.tcp.DataFlusher;
import jayeson.lib.delivery.core.tcp.LengthDecoder;
import jayeson.lib.delivery.core.tcp.LengthEncoder;

public class TCPTransport
extends AbstractTransport {
    protected LengthEncoder lengthEncoder;
    protected LengthDecoder lengthDecoder;

    @Override
    public List<NamedHandler> getDefaultHandlers() {
        ArrayList<NamedHandler> returnList = new ArrayList<NamedHandler>();
        returnList.add(this.dataFlusher);
        returnList.add(this.lengthEncoder);
        returnList.add(this.lengthDecoder);
        returnList.add(this.idleStateNotifier);
        returnList.add(this.idleStateListener);
        returnList.add(this.transportExceptionNotifier);
        return returnList;
    }

    protected void checkAndAddKeepAlive(List<NamedHandler> returnList) {
        Boolean isEnabled = this.getEndPoint().getState(KeepAliveConstants.ATTR_KEEP_ALIVE);
        if (isEnabled != null && isEnabled.booleanValue()) {
            Integer keepAliveInterval = this.getEndPoint().getState(KeepAliveConstants.ATTR_KEEP_ALIVE_INTERVAL);
            if (keepAliveInterval == null) {
                keepAliveInterval = 5000;
            }
            this.idleStateNotifier = new IdleStateNotifier(0, 0, keepAliveInterval, TimeUnit.MILLISECONDS);
            returnList.add(this.idleStateNotifier);
            returnList.add(this.idleStateListener);
        }
    }

    @Inject
    public void setLengthEncoder(LengthEncoder lengthEncoder) {
        this.lengthEncoder = lengthEncoder;
    }

    @Inject
    public void setLengthDecoder(LengthDecoder lengthDecoder) {
        this.lengthDecoder = lengthDecoder;
    }

    @Override
    @Inject
    public void setDataFlusher(DataFlusher dataFlusher) {
        this.dataFlusher = dataFlusher;
    }

    @Override
    public void attach(ChannelPipeline pipeline) {
        super.attach(pipeline);
        Boolean isEnabled = (Boolean)pipeline.channel().attr(KeepAliveConstants.ATTR_KEEP_ALIVE).get();
        if (isEnabled != null && isEnabled.booleanValue()) {
            Integer keepAliveInterval = (Integer)pipeline.channel().attr(KeepAliveConstants.ATTR_KEEP_ALIVE_INTERVAL).get();
            if (keepAliveInterval == null) {
                keepAliveInterval = 5000;
            }
            this.idleStateNotifier = new IdleStateNotifier(0, 0, keepAliveInterval, TimeUnit.MILLISECONDS);
            pipeline.replace(this.idleStateNotifier.getName(), this.idleStateNotifier.getName(), (ChannelHandler)this.idleStateNotifier);
        }
    }
}

