/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core.tcp;

import com.google.inject.Inject;
import com.google.inject.Injector;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufProcessor;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ByteProcessor;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import jayeson.lib.delivery.api.CoreComponent;
import jayeson.lib.delivery.api.ITransport;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.core.http.HttpRouter;
import jayeson.lib.delivery.core.http.HttpTransport;
import jayeson.lib.delivery.core.tcp.TCPRouter;
import jayeson.lib.delivery.core.tcp.TCPTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportDetector
extends ChannelInboundHandlerAdapter
implements NamedHandler {
    public static final String DETECT_CHARSET = "UTF-8";
    public static final String HTTP_STRING = "HTTP/1.1";
    private static final Logger log = LoggerFactory.getLogger(TransportDetector.class);
    private ITransport transport;
    @Inject
    private static Injector injector;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws UnsupportedEncodingException {
        String expected;
        ByteBuf x = (ByteBuf)msg;
        Channel sc = ctx.channel();
        String firstHandler = "";
        firstHandler = !TransportDetector.hasNewLine(x) ? this.setupTCPTransport(sc) : ((expected = TransportDetector.getFirstLine(x)).contains(HTTP_STRING) ? this.setupHttpTransport(sc) : this.setupTCPTransport(sc));
        sc.pipeline().context(firstHandler).fireChannelRead(msg);
    }

    private String setupTCPTransport(Channel sc) {
        String firstHandler = "";
        ITransport transport = (ITransport)injector.getInstance(TCPTransport.class);
        firstHandler = transport.getDefaultHandlers().get(0).getName();
        log.info("Detected Transport is TCP.Changing Transport to TCP.Address {} ", (Object)sc.remoteAddress().toString());
        this.transport.getEndPoint().changeCoreComponent(transport).changeCoreComponent((CoreComponent)injector.getInstance(TCPRouter.class));
        return firstHandler;
    }

    private String setupHttpTransport(Channel sc) {
        String firstHandler = "";
        ITransport transport = (ITransport)injector.getInstance(HttpTransport.class);
        firstHandler = transport.getDefaultHandlers().get(0).getName();
        log.info("Detected Transport is HTTP. Changing Transport to HTTP.Address {}", (Object)sc.remoteAddress().toString());
        this.transport.getEndPoint().changeCoreComponent(transport).changeCoreComponent((CoreComponent)injector.getInstance(HttpRouter.class));
        return firstHandler;
    }

    @Override
    public String getName() {
        return "TRANSPORT_DETECTOR";
    }

    public ITransport getTransport() {
        return this.transport;
    }

    public void setTransport(ITransport transport) {
        this.transport = transport;
    }

    private static boolean hasNewLine(ByteBuf x) {
        int crlf = x.forEachByte((ByteProcessor)ByteBufProcessor.FIND_LF);
        return crlf != -1;
    }

    public static String getFirstLine(ByteBuf x) throws UnsupportedEncodingException {
        final ArrayList firstLine = new ArrayList();
        x.forEachByte((ByteProcessor)new ByteBufProcessor(){

            public boolean process(byte value) throws Exception {
                firstLine.add(value);
                return value != 10;
            }
        });
        byte[] byteArray = new byte[firstLine.size()];
        for (int i = 0; i < firstLine.size(); ++i) {
            byteArray[i] = (Byte)firstLine.get(i);
        }
        String expected = new String(byteArray, DETECT_CHARSET);
        x.resetReaderIndex();
        return expected;
    }

    public static Injector getInjector() {
        return injector;
    }

    public static void setInjector(Injector injector) {
        TransportDetector.injector = injector;
    }
}

