/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.auth;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import javax.inject.Singleton;
import jayeson.lib.access.AccessManagerFactory;
import jayeson.lib.access.dagger.DaggerAccessManagerComponent;
import jayeson.lib.delivery.module.auth.AuthContentWaiter;
import jayeson.lib.delivery.module.auth.AuthService;
import jayeson.lib.delivery.module.auth.AuthServiceConfig;
import jayeson.lib.delivery.module.auth.IAuthService;
import jayeson.lib.session.SessionModelFactory;
import jayeson.lib.session.dagger.DaggerSessionComponent;
import jayeson.lib.session.dagger.SessionComponent;
import jayeson.utility.UtilityModule;
import jayeson.utility.crypto.Crypto;

public class AuthModule
extends AbstractModule {
    private AuthServiceConfig config;

    public AuthModule(AuthServiceConfig config) {
        this.config = config;
    }

    @Provides
    @Singleton
    public Crypto provideCrypto() {
        return new Crypto();
    }

    protected void configure() {
        this.bind(AuthServiceConfig.class).toInstance((Object)this.config);
        SessionComponent sessionComponent = DaggerSessionComponent.create();
        AccessManagerFactory accessManagerFactory = DaggerAccessManagerComponent.builder().sessionComp(sessionComponent).build().factory();
        this.bind(AccessManagerFactory.class).toInstance((Object)accessManagerFactory);
        this.bind(SessionModelFactory.class).toInstance((Object)sessionComponent.factory());
        this.install(new FactoryModuleBuilder().build(AuthContentWaiter.F.class));
        this.install((Module)new UtilityModule());
        this.bind(AuthService.class);
        this.bind(IAuthService.class).to(AuthService.class);
    }
}

