/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.publisher;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Set;
import jayeson.lib.delivery.api.IRouter;
import jayeson.lib.delivery.api.IServer;
import jayeson.lib.delivery.api.ITransport;
import jayeson.lib.delivery.api.ServerConfig;
import jayeson.lib.delivery.api.SslConfig;
import jayeson.lib.delivery.core.CoreComponentFactory;
import jayeson.lib.delivery.core.http.HttpRouter;
import jayeson.lib.delivery.core.http.HttpTransport;
import jayeson.lib.delivery.core.server.DefaultServer;
import jayeson.lib.delivery.core.server.DefaultServerModule;
import jayeson.lib.delivery.core.ssl.InitialSSLTransport;
import jayeson.lib.delivery.core.ssl.SSLTransport;
import jayeson.lib.delivery.core.ssl.SecureServerModule;
import jayeson.lib.delivery.core.tcp.InitialRouter;
import jayeson.lib.delivery.core.tcp.InitialTransport;
import jayeson.lib.delivery.core.tcp.TCPRouter;
import jayeson.lib.delivery.core.tcp.TCPTransport;
import jayeson.lib.delivery.module.publisher.IPublisher;
import jayeson.lib.delivery.module.publisher.NamedCoreComponentFactory;
import jayeson.lib.delivery.module.publisher.Publisher;
import jayeson.lib.delivery.module.publisher.PublisherConfig;
import jayeson.lib.delivery.module.publisher.TransportMode;
import jayeson.lib.delivery.module.publisher.server.MultiPortBoundServer;
import jayeson.lib.delivery.module.publisher.server.MultiPortServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPublisherModule
implements Module {
    private static Logger log = LoggerFactory.getLogger(DefaultPublisherModule.class);
    private PublisherConfig publisherConfig;

    public DefaultPublisherModule(PublisherConfig publisherConfig) {
        this.publisherConfig = publisherConfig;
    }

    public void configure(Binder binder) {
        if (this.publisherConfig.getServerConfig() instanceof MultiPortServerConfig) {
            binder.bind(IServer.class).to(MultiPortBoundServer.class);
            this.bindRouterAndTransportToNamedCCFactory(binder);
            binder.bind(MultiPortServerConfig.class).toInstance((Object)((MultiPortServerConfig)this.publisherConfig.getServerConfig()));
        } else {
            if (this.isSslEnabled() && this.isTcpEnabled() && !(this.publisherConfig.getServerConfig() instanceof MultiPortServerConfig)) {
                throw new RuntimeException("TCP and SSL Both are enabled. Make sure configuration is MultiPortServerConfig");
            }
            binder.bind(IServer.class).to(DefaultServer.class);
            this.bindRouterAndTransportToCCFactory(binder);
            binder.bind(ServerConfig.class).toInstance((Object)this.publisherConfig.getServerConfig());
        }
        binder.bind(PublisherConfig.class).toInstance((Object)this.publisherConfig);
        binder.bind(IPublisher.class).to(Publisher.class);
        if (this.isSslEnabled()) {
            log.info("Ssl Transport mode is enabled.Installing SecureServermodule");
            SslConfig sslConfig = this.publisherConfig.getServerConfig().getSslConfig();
            binder.install((Module)new SecureServerModule(sslConfig));
        } else {
            log.info("Ssl Transport is NOT enabled.Installing DefaultServerModule");
            binder.install((Module)new DefaultServerModule());
        }
    }

    private boolean isSslEnabled() {
        Set<TransportMode> supportedTransports = this.publisherConfig.getSupportedTransport();
        for (TransportMode mode : supportedTransports) {
            if (!mode.isSsl()) continue;
            return true;
        }
        return false;
    }

    private boolean isTcpEnabled() {
        Set<TransportMode> supportedTransports = this.publisherConfig.getSupportedTransport();
        for (TransportMode mode : supportedTransports) {
            if (mode.isSsl()) continue;
            return true;
        }
        return false;
    }

    private void bindRouterAndTransportToNamedCCFactory(Binder binder) {
        Set<TransportMode> supportedTransports = this.publisherConfig.getSupportedTransport();
        Class tcpTransportBind = null;
        Class sslTransportBind = null;
        Class tcpRouterBind = null;
        Class sslRouterBind = null;
        if (supportedTransports.contains((Object)TransportMode.TCP) && (supportedTransports.contains((Object)TransportMode.WS) || supportedTransports.contains((Object)TransportMode.HTTP))) {
            log.info("Binding Initial Transport and Initial Router for TCP Server");
            tcpTransportBind = InitialTransport.class;
            tcpRouterBind = InitialRouter.class;
        } else if (supportedTransports.contains((Object)TransportMode.TCP)) {
            log.info("Binding TcpRouter and TcpTransport for TCP Server");
            tcpTransportBind = TCPTransport.class;
            tcpRouterBind = TCPRouter.class;
        } else if (supportedTransports.contains((Object)TransportMode.WS) || supportedTransports.contains((Object)TransportMode.HTTP)) {
            log.info("Binding HttpTransport and HttpRouter for TCP Server");
            tcpTransportBind = HttpTransport.class;
            tcpRouterBind = HttpRouter.class;
        }
        if (supportedTransports.contains((Object)TransportMode.SSL) && (supportedTransports.contains((Object)TransportMode.WSS) || supportedTransports.contains((Object)TransportMode.HTTPS))) {
            log.info("Binding Initial SSlTransport and Initial Router for ssl Server");
            sslTransportBind = InitialSSLTransport.class;
            sslRouterBind = InitialRouter.class;
        } else if (supportedTransports.contains((Object)TransportMode.SSL)) {
            log.info("Binding TcpRouter and SslTransport for Ssl Server");
            sslTransportBind = SSLTransport.class;
            sslRouterBind = TCPRouter.class;
        } else if (supportedTransports.contains((Object)TransportMode.WSS) || supportedTransports.contains((Object)TransportMode.HTTPS)) {
            log.info("Since we dont have explicit Https transport yet, we will bind Intial Transport and Inital Router for Ssl Server");
            sslTransportBind = InitialSSLTransport.class;
            sslRouterBind = InitialRouter.class;
        }
        FactoryModuleBuilder namedCoreComponentModuleBuilder = new FactoryModuleBuilder();
        if (tcpTransportBind != null) {
            namedCoreComponentModuleBuilder.implement(ITransport.class, (Annotation)Names.named((String)"tcp"), tcpTransportBind);
            namedCoreComponentModuleBuilder.implement(IRouter.class, (Annotation)Names.named((String)"tcp"), tcpRouterBind);
        }
        if (sslTransportBind != null) {
            namedCoreComponentModuleBuilder.implement(ITransport.class, (Annotation)Names.named((String)"ssl"), sslTransportBind);
            namedCoreComponentModuleBuilder.implement(IRouter.class, (Annotation)Names.named((String)"ssl"), sslRouterBind);
        }
        binder.install(namedCoreComponentModuleBuilder.build(NamedCoreComponentFactory.class));
        FactoryModuleBuilder coreComponentModuleBuilder = new FactoryModuleBuilder();
        coreComponentModuleBuilder.implement(ITransport.class, InitialTransport.class);
        coreComponentModuleBuilder.implement(IRouter.class, InitialRouter.class);
        binder.install(coreComponentModuleBuilder.build(CoreComponentFactory.class));
    }

    private void bindRouterAndTransportToCCFactory(Binder binder) {
        Set<TransportMode> supportedTransports = this.publisherConfig.getSupportedTransport();
        Class transportBind = null;
        Class routerBind = null;
        if (supportedTransports.contains((Object)TransportMode.TCP) && (supportedTransports.contains((Object)TransportMode.WS) || supportedTransports.contains((Object)TransportMode.HTTP))) {
            log.info("Binding Initial Transport and Initial Router for TCP Server");
            transportBind = InitialTransport.class;
            routerBind = InitialRouter.class;
        } else if (supportedTransports.contains((Object)TransportMode.TCP)) {
            log.info("Binding TcpRouter and TcpTransport for TCP Server");
            transportBind = TCPTransport.class;
            routerBind = TCPRouter.class;
        } else if (supportedTransports.contains((Object)TransportMode.WS) || supportedTransports.contains((Object)TransportMode.HTTP)) {
            log.info("Binding HttpTransport and HttpRouter for TCP Server");
            transportBind = HttpTransport.class;
            routerBind = HttpRouter.class;
        }
        if (supportedTransports.contains((Object)TransportMode.SSL) && (supportedTransports.contains((Object)TransportMode.WSS) || supportedTransports.contains((Object)TransportMode.HTTPS))) {
            log.info("Binding Initial SSlTransport and Initial Router for ssl Server");
            transportBind = InitialSSLTransport.class;
            routerBind = InitialRouter.class;
        } else if (supportedTransports.contains((Object)TransportMode.SSL)) {
            log.info("Binding TcpRouter and SslTransport for Ssl Server");
            transportBind = SSLTransport.class;
            routerBind = TCPRouter.class;
        } else if (supportedTransports.contains((Object)TransportMode.WSS) || supportedTransports.contains((Object)TransportMode.HTTPS)) {
            log.info("Since we dont have explicit Https transport yet, we will bind Intial Transport and Inital Router for Ssl Server");
            transportBind = InitialSSLTransport.class;
            routerBind = InitialRouter.class;
        }
        FactoryModuleBuilder coreComponentModuleBuilder = new FactoryModuleBuilder();
        coreComponentModuleBuilder.implement(ITransport.class, transportBind);
        coreComponentModuleBuilder.implement(IRouter.class, routerBind);
        binder.install(coreComponentModuleBuilder.build(CoreComponentFactory.class));
    }
}

