/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.streamregistry;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.IEndPointListener;
import jayeson.lib.delivery.api.events.EPDisconnectedEvent;
import jayeson.lib.delivery.api.events.EPEvent;
import jayeson.lib.delivery.api.events.IEPEventDispatcher;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.EndPoint;
import jayeson.lib.delivery.module.ModuleUtility;
import jayeson.lib.delivery.module.auth.event.AuthSuccessful;
import jayeson.lib.delivery.module.streamregistry.GroupStream;
import jayeson.lib.delivery.module.streamregistry.IStreamRegistry;
import jayeson.lib.delivery.module.streamregistry.ProfileCache;
import jayeson.lib.delivery.module.streamregistry.StreamRegistryGroupProcessor;
import jayeson.lib.delivery.module.streamregistry.event.StopStreamPublishingEvent;
import jayeson.lib.delivery.module.streamregistry.event.StreamDeRegistrationCompleteEvent;
import jayeson.lib.delivery.module.streamregistry.event.StreamRegistrationCompleteEvent;
import jayeson.lib.delivery.module.streamregistry.event.StreamRegistryEvent;
import jayeson.lib.delivery.module.streamregistry.messages.StreamRegistryMessageGroup;
import jayeson.lib.delivery.module.streamregistry.messages.StreamRegistryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StreamRegistry
implements IStreamRegistry {
    private static Logger log = LoggerFactory.getLogger(StreamRegistry.class);
    private IEPEventDispatcher eventDispatcher;
    private StreamRegistryGroupProcessor streamRegistryGroupProcessor;
    private ProfileCache profileCache;
    @Inject
    private StreamRegistryMessageGroup streamRegistryMessageGroup;

    @Inject
    public StreamRegistry(StreamRegistryGroupProcessor streamRegistryGroupProcessor) {
        this.streamRegistryGroupProcessor = streamRegistryGroupProcessor;
        this.eventDispatcher = this.streamRegistryGroupProcessor.getEventDispatcher();
        this.profileCache = this.streamRegistryGroupProcessor.getProfileCache();
    }

    @Override
    public void attachListener(IEndPointListener listener) {
        this.eventDispatcher.registerListener(listener);
    }

    @Override
    public void detachListener(IEndPointListener listener) {
        this.eventDispatcher.deregisterListener(listener);
    }

    @Override
    public void onEvent(EPEvent event) {
        ScheduledExecutorService ex = StreamRegistryGroupProcessor.streamRegistryExctor;
        if (event instanceof AuthSuccessful) {
            ex.submit(() -> {
                AuthSuccessful authSuccessEvent = (AuthSuccessful)event;
                this.profileCache.saveUserState(authSuccessEvent.getScope(), authSuccessEvent.getUsername(), event.getEndpoint());
            });
        } else if (event instanceof EPDisconnectedEvent) {
            ex.submit(() -> this.profileCache.dropUserState(event.getEndpoint()));
        } else if (event instanceof StreamRegistrationCompleteEvent) {
            ex.submit(() -> {
                StreamRegistrationCompleteEvent strRegCompEvent = (StreamRegistrationCompleteEvent)event;
                Set<String> successfulStreams = strRegCompEvent.getStreamsWithStatus(StreamRegistryEvent.StreamNegotiationStatus.SUCCESS);
                if (!ModuleUtility.isNullOrEmpty(successfulStreams)) {
                    this.profileCache.annotateStreamAsRegistered(event.getEndpoint(), strRegCompEvent.getMessageGroup(), successfulStreams);
                }
                HashMap<String, Integer> streamsInResponse = new HashMap<String, Integer>();
                Map<String, StreamRegistryEvent.StreamNegotiationStatus> streamsInEvent = strRegCompEvent.getStreams();
                Byte messageGroup = strRegCompEvent.getMessageGroup();
                if (streamsInEvent != null) {
                    for (String stream : streamsInEvent.keySet()) {
                        StreamRegistryEvent.StreamNegotiationStatus status = streamsInEvent.get(stream);
                        if (status == StreamRegistryEvent.StreamNegotiationStatus.SUCCESS) {
                            streamsInResponse.put(stream, 4);
                            continue;
                        }
                        if (status == StreamRegistryEvent.StreamNegotiationStatus.FAIL) {
                            streamsInResponse.put(stream, 5);
                            continue;
                        }
                        log.error("Cannot Convert Status of Stream in Event {} to Status in RegistraionResponse {} for group {}", (Object)status, (Object)messageGroup);
                    }
                }
                StreamRegistryResponse registrationResponse = new StreamRegistryResponse(messageGroup, streamsInResponse, 0);
                registrationResponse.setComment(strRegCompEvent.getComment());
                MessageWrapper mw = new MessageWrapper(registrationResponse, this.streamRegistryMessageGroup.classById((byte)1));
                this._send(strRegCompEvent.getEndpoint(), mw);
            });
        } else if (event instanceof StreamDeRegistrationCompleteEvent) {
            ex.submit(() -> {
                StreamDeRegistrationCompleteEvent strDeRegCompEvent = (StreamDeRegistrationCompleteEvent)event;
                Set<String> successfulStreams = strDeRegCompEvent.getStreamsWithStatus(StreamRegistryEvent.StreamNegotiationStatus.SUCCESS);
                if (!ModuleUtility.isNullOrEmpty(successfulStreams)) {
                    this.profileCache.annotateStreamAsDeregistered(event.getEndpoint(), strDeRegCompEvent.getMessageGroup(), successfulStreams);
                }
                HashMap<String, Integer> streamsInResponse = new HashMap<String, Integer>();
                Map<String, StreamRegistryEvent.StreamNegotiationStatus> streamsInEvent = strDeRegCompEvent.getStreams();
                Byte messageGroup = strDeRegCompEvent.getMessageGroup();
                if (streamsInEvent != null) {
                    for (String stream : streamsInEvent.keySet()) {
                        StreamRegistryEvent.StreamNegotiationStatus status = streamsInEvent.get(stream);
                        if (status == StreamRegistryEvent.StreamNegotiationStatus.SUCCESS) {
                            streamsInResponse.put(stream, 4);
                            continue;
                        }
                        if (status == StreamRegistryEvent.StreamNegotiationStatus.FAIL) {
                            streamsInResponse.put(stream, 5);
                            continue;
                        }
                        log.error("Cannot Convert Status of Stream in Event {} to Status in DeRegistraionResponse {} for group {}", (Object)status, (Object)messageGroup);
                    }
                }
                StreamRegistryResponse deRegistrationResponse = new StreamRegistryResponse(messageGroup, streamsInResponse, 2);
                deRegistrationResponse.setComment(strDeRegCompEvent.getComment());
                MessageWrapper mw = new MessageWrapper(deRegistrationResponse, this.streamRegistryMessageGroup.classById((byte)1));
                this._send(strDeRegCompEvent.getEndpoint(), mw);
            });
        }
    }

    private void _send(IEndPoint ep, MessageWrapper mw) {
        try {
            ep.send(mw);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    @Override
    public Set<String> getConsumingStreams(byte group, IEndPoint ep) {
        return this.profileCache.getConsumingStreams(ep, group);
    }

    @Override
    public IMessageGroupProcessor getProcessor() {
        return this.streamRegistryGroupProcessor;
    }

    public StreamRegistryGroupProcessor getStreamRegistryGroupProcessor() {
        return this.streamRegistryGroupProcessor;
    }

    @Override
    public Set<IEndPoint> getConsumingEndPoints(byte messageGroup, String stream) {
        return this.profileCache.getConsumingEndPoints(messageGroup, stream);
    }

    public StreamRegistryMessageGroup getStreamRegistryMessageGroup() {
        return this.streamRegistryMessageGroup;
    }

    public void setStreamRegistryMessageGroup(StreamRegistryMessageGroup streamRegistryMessageGroup) {
        this.streamRegistryMessageGroup = streamRegistryMessageGroup;
    }

    @Override
    public String getUserName(IEndPoint endpoint) {
        return this.profileCache.getUserid(endpoint);
    }

    @Override
    public CompletableFuture<Void> blockStream(long timeout, byte group, String streamName) {
        GroupStream gs = new GroupStream(group, streamName);
        BlockStreamTask bt = new BlockStreamTask(gs, timeout);
        StreamRegistryGroupProcessor.streamRegistryExctor.submit(bt);
        return bt.sendFinish;
    }

    private class BlockStreamTask
    implements Runnable {
        CompletableFuture<Void> sendFinish = new CompletableFuture();
        GroupStream gs;
        long timeout;
        AtomicInteger counter;

        public BlockStreamTask(GroupStream gs, long timeout) {
            this.gs = gs;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            if (StreamRegistry.this.profileCache.isStreamBlocked(this.gs)) {
                return;
            }
            Set<IEndPoint> epSet = StreamRegistry.this.profileCache.getConsumingEndPoints(this.gs.getGroup(), this.gs.getStream());
            StreamRegistry.this.profileCache.blockStream(this.gs, this.timeout, StreamRegistryGroupProcessor.streamRegistryExctor);
            if (epSet.isEmpty()) {
                this.sendFinish.complete(null);
            } else {
                this.counter = new AtomicInteger(epSet.size());
                for (IEndPoint ep : epSet) {
                    try {
                        HashMap<String, Integer> stopStreams = new HashMap<String, Integer>();
                        stopStreams.put(this.gs.getStream(), 4);
                        StreamRegistryResponse stopConsumption = new StreamRegistryResponse(this.gs.getGroup(), stopStreams, 6);
                        ((EndPoint)ep).send(new MessageWrapper(stopConsumption, ((StreamRegistry)StreamRegistry.this).streamRegistryMessageGroup.STREAMREGISTRY_RESPONSE), new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                int count = BlockStreamTask.this.counter.decrementAndGet();
                                if (count == 0) {
                                    BlockStreamTask.this.sendFinish.complete(null);
                                }
                            }
                        });
                        HashSet<String> streams = new HashSet<String>();
                        streams.add(this.gs.getStream());
                        StreamRegistry.this.profileCache.annotateStreamAsDeregistered(ep, this.gs.getGroup(), streams);
                        StopStreamPublishingEvent stopEvent = new StopStreamPublishingEvent(ep, this.gs.getGroup());
                        HashMap<String, StreamRegistryEvent.StreamNegotiationStatus> streamMap = new HashMap<String, StreamRegistryEvent.StreamNegotiationStatus>();
                        streamMap.put(this.gs.getStream(), StreamRegistryEvent.StreamNegotiationStatus.SUCCESS);
                        stopEvent.setStreams(streamMap);
                        StreamRegistry.this.eventDispatcher.dispatchEvent(stopEvent);
                    }
                    catch (Exception e) {
                        log.error("Error while blocking Stream", (Throwable)e);
                    }
                }
            }
        }
    }
}

