/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.subscriber;

import jayeson.lib.delivery.api.IClient;
import jayeson.lib.delivery.module.subscriber.ConnectionState;
import jayeson.lib.delivery.module.subscriber.ConnectionSupervisor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectClientTask
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(ConnectClientTask.class);
    private IClient client;
    private String serviceId;
    private ConnectionSupervisor sourceConnectionSupervisor;

    public ConnectClientTask(ConnectionSupervisor sourceConnectionSupervisor, IClient client, String serviceId) {
        this.client = client;
        this.serviceId = serviceId;
        this.sourceConnectionSupervisor = sourceConnectionSupervisor;
    }

    @Override
    public void run() {
        IClient c = this.client.connect();
        if (c == null) {
            log.error("Cannot connect to client {} {}", (Object)this.client.configuration().getHost(), (Object)this.client.configuration().getPort());
            this.sourceConnectionSupervisor.annotateClient(this.serviceId, ConnectionState.DISCONNECTED);
        }
        this.sourceConnectionSupervisor.doPostConnectionCheck(this.serviceId);
    }
}

