/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.subscriber;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import jayeson.lib.delivery.api.IClient;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.IEndPointListener;
import jayeson.lib.delivery.module.subscriber.ClientFactory;
import jayeson.lib.delivery.module.subscriber.ConnectClientTask;
import jayeson.lib.delivery.module.subscriber.ConnectionInfo;
import jayeson.lib.delivery.module.subscriber.ConnectionState;
import jayeson.lib.delivery.module.subscriber.DisconnectClientTask;
import jayeson.lib.delivery.module.subscriber.ReconnectClientTask;
import jayeson.lib.delivery.module.subscriber.ScopedSubscriber;
import jayeson.lib.delivery.module.subscriber.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionSupervisor {
    private static Logger log = LoggerFactory.getLogger(ConnectionSupervisor.class);
    private Map<String, ConnectionInfo> connectionInfoMap = new HashMap<String, ConnectionInfo>();
    private ScheduledExecutorService executor;
    private Object objectLock = new Object();
    ClientFactory clientFactory;
    private ReconnectClientTask reconnectionTask;
    ScheduledFuture<?> reconnectFuture;
    private ScopedSubscriber subscriber;
    private boolean isStopped;

    @Inject
    public ConnectionSupervisor(@Named(value="SUBSCRIBER_EXECUTOR") ScheduledExecutorService executorService) {
        this.executor = executorService;
    }

    public void connectToSource(StreamSource source, IEndPointListener listener) {
        String serviceId = source.serviceId;
        URI sourceUri = source.uri;
        if (this.hasActiveConnection(serviceId)) {
            log.warn("Client already connected to  {} {}. Not taking any action", (Object)sourceUri.getHost(), (Object)sourceUri.getPort());
        } else {
            ConnectionInfo existingConnection = this.getConnectionInfo(source.serviceId);
            if (existingConnection == null) {
                this._connect(source, listener);
            } else if (existingConnection.isLifeCycleComplete()) {
                this._connect(source, listener);
            }
        }
    }

    private void _connect(StreamSource source, IEndPointListener listener) {
        URI sourceUri = source.uri;
        IClient client = null;
        client = sourceUri.getScheme().equals("tcp") ? this.clientFactory.create("tcp") : (sourceUri.getScheme().equals("ssl") ? this.clientFactory.create("ssl") : this.clientFactory.create(""));
        client.configuration().setHost(sourceUri.getHost());
        client.configuration().setPort(sourceUri.getPort());
        if (listener != null) {
            client.attachListener(listener);
        }
        ConnectionInfo newConnectionInfo = this.addClientToServiceIdMap(source.serviceId, client);
        if (this.subscriber.isTicketAvailable()) {
            this.connectClient(newConnectionInfo);
        } else {
            this.annotateClient(source.serviceId, ConnectionState.WAITING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectSource(String serviceId) {
        ConnectionInfo connectionInfo = null;
        Object object = this.objectLock;
        synchronized (object) {
            connectionInfo = this.connectionInfoMap.get(serviceId);
        }
        if (connectionInfo != null) {
            IClient client = connectionInfo.getClient();
            log.debug("Disconnecting from source {} {}", (Object)client.configuration().getHost(), (Object)client.configuration().getPort());
            this.executor.execute(new DisconnectClientTask(this, client, serviceId));
            connectionInfo.setLifeCycleComplete(true);
        }
    }

    protected boolean hasActiveConnection(String serviceId) {
        ConnectionInfo connectionInfo = this.getConnectionInfo(serviceId);
        if (connectionInfo == null) {
            return false;
        }
        return ConnectionState.isActive(connectionInfo.getState());
    }

    protected IClient getClient(String serviceId) {
        ConnectionInfo connectionInfo = this.getConnectionInfo(serviceId);
        if (connectionInfo == null) {
            return null;
        }
        return connectionInfo.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionInfo getConnectionInfo(IEndPoint ep) {
        Object object = this.objectLock;
        synchronized (object) {
            for (ConnectionInfo connectionInfo : this.connectionInfoMap.values()) {
                IEndPoint e = connectionInfo.getClient().getEndPoint();
                if (e != ep) continue;
                return connectionInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IClient getClient(IEndPoint ep) {
        Object object = this.objectLock;
        synchronized (object) {
            for (ConnectionInfo connectionInfo : this.connectionInfoMap.values()) {
                IEndPoint e = connectionInfo.getClient().getEndPoint();
                if (e != ep) continue;
                return connectionInfo.getClient();
            }
        }
        return null;
    }

    protected String getServiceId(IEndPoint ep) {
        ConnectionInfo c = this.getConnectionInfo(ep);
        if (c == null) {
            return null;
        }
        return c.getServiceId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionInfo getConnectionInfo(String serviceId) {
        Object object = this.objectLock;
        synchronized (object) {
            return this.connectionInfoMap.get(serviceId);
        }
    }

    protected ConnectionState getConnectionState(String serviceId) {
        ConnectionInfo connectionInfo = this.connectionInfoMap.get(serviceId);
        if (connectionInfo == null) {
            return null;
        }
        return connectionInfo.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionInfo addClientToServiceIdMap(String serviceId, IClient client) {
        Object object = this.objectLock;
        synchronized (object) {
            ConnectionInfo existing = this.connectionInfoMap.get(serviceId);
            if (existing != null) {
                log.info("Client already exists with serviceId {} with state {}.Replacing", (Object)serviceId, (Object)existing.getState());
            }
            ConnectionInfo newConnectionInfo = new ConnectionInfo(serviceId, client);
            this.connectionInfoMap.put(serviceId, newConnectionInfo);
            return newConnectionInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotateClient(String serviceId, ConnectionState connectionState) {
        Object object = this.objectLock;
        synchronized (object) {
            ConnectionInfo connectionInfo = this.connectionInfoMap.get(serviceId);
            connectionInfo.changeState(connectionState);
        }
    }

    public void cleanUp() {
        if (this.isStopped) {
            boolean allDisconnected = true;
            for (ConnectionInfo connectionInfo : this.connectionInfoMap.values()) {
                if (connectionInfo.getState() == ConnectionState.DISCONNECTED) continue;
                allDisconnected = false;
                break;
            }
            if (allDisconnected) {
                this.executor.shutdown();
            }
        }
    }

    public void annotateClient(IEndPoint endPoint, ConnectionState connectionState) {
        ConnectionInfo connectionInfo = this.getConnectionInfo(endPoint);
        connectionInfo.changeState(connectionState);
    }

    public void dropState(IEndPoint endpoint) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IClient> getAuthenticatedClients() {
        HashSet<IClient> authenticatedClients = new HashSet<IClient>();
        Object object = this.objectLock;
        synchronized (object) {
            for (ConnectionInfo connectionInfo : this.connectionInfoMap.values()) {
                if (!ConnectionState.isAuthenticationDone(connectionInfo.getState())) continue;
                authenticatedClients.add(connectionInfo.getClient());
            }
        }
        return authenticatedClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ConnectionInfo> getDisconnectedClients() {
        HashSet<ConnectionInfo> disconnectedClients = new HashSet<ConnectionInfo>();
        Object object = this.objectLock;
        synchronized (object) {
            for (ConnectionInfo connectionInfo : this.connectionInfoMap.values()) {
                if (connectionInfo.getState() != ConnectionState.DISCONNECTED || connectionInfo.isLifeCycleComplete()) continue;
                disconnectedClients.add(connectionInfo);
            }
        }
        return disconnectedClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectWaitingClients() {
        Object object = this.objectLock;
        synchronized (object) {
            for (ConnectionInfo connectionInfo : this.connectionInfoMap.values()) {
                if (connectionInfo.getState() != ConnectionState.WAITING) continue;
                this.connectClient(connectionInfo);
            }
        }
    }

    protected void connectClient(ConnectionInfo connectionInfo) {
        connectionInfo.changeState(ConnectionState.CONNECTING);
        this.executor.execute(new ConnectClientTask(this, connectionInfo.getClient(), connectionInfo.getServiceId()));
    }

    public ScopedSubscriber getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(ScopedSubscriber subscriber) {
        this.subscriber = subscriber;
    }

    public ClientFactory getClientFactory() {
        return this.clientFactory;
    }

    @Inject
    public void setClientFactory(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    protected void handleReconnectionFail(ConnectionInfo connectionInfo) {
        this.subscriber.handleReconnectionFail(connectionInfo.getServiceId());
    }

    public void doPostConnectionCheck(String serviceId) {
        this.subscriber.checkForAbortedSources(serviceId);
    }

    public void start() {
        if (this.reconnectFuture == null) {
            this.reconnectFuture = this.executor.scheduleWithFixedDelay(this.reconnectionTask, 0L, this.reconnectionTask.checkIntervalMs, TimeUnit.MILLISECONDS);
        } else {
            log.warn("Reconnect task is already started. Not starting again.");
        }
    }

    public void stop() {
        if (this.reconnectFuture != null) {
            this.reconnectFuture.cancel(true);
        }
        this.isStopped = true;
    }

    public ReconnectClientTask getReconnectionTask() {
        return this.reconnectionTask;
    }

    @Inject
    public void setReconnectionTask(ReconnectClientTask reconnectionTask) {
        this.reconnectionTask = reconnectionTask;
        reconnectionTask.setConnectionSupervisor(this);
    }
}

