/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.subscriber;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import jayeson.lib.delivery.api.IClient;
import jayeson.lib.delivery.api.IRouter;
import jayeson.lib.delivery.api.ITransport;
import jayeson.lib.delivery.core.CoreComponentFactory;
import jayeson.lib.delivery.core.ssl.SecureClientModule;
import jayeson.lib.delivery.core.tcp.DefaultRouterModule;
import jayeson.lib.delivery.core.tcp.DefaultTransportModule;
import jayeson.lib.delivery.core.tcp.TCPRouter;
import jayeson.lib.delivery.core.tcp.TCPTransport;
import jayeson.lib.delivery.module.ModuleUtility;
import jayeson.lib.delivery.module.subscriber.AuthenticationSupervisorFactory;
import jayeson.lib.delivery.module.subscriber.ClientFactory;
import jayeson.lib.delivery.module.subscriber.ConcreteTransportFactory;
import jayeson.lib.delivery.module.subscriber.DiscoverySupervisorFactory;
import jayeson.lib.delivery.module.subscriber.ISubscriber;
import jayeson.lib.delivery.module.subscriber.ScopedSubscriberFactory;
import jayeson.lib.delivery.module.subscriber.Subscriber;
import jayeson.lib.delivery.module.subscriber.SubscriberConfig;
import jayeson.lib.delivery.module.subscriber.TransportAwareClient;

public class DefaultSubscriberModule
implements Module {
    private SubscriberConfig subscriberConfig;

    public DefaultSubscriberModule() {
    }

    public DefaultSubscriberModule(SubscriberConfig subscriberConfig) {
        this();
        this.subscriberConfig = subscriberConfig;
    }

    public void configure(Binder binder) {
        if (this.subscriberConfig != null) {
            binder.bind(SubscriberConfig.class).toInstance((Object)this.subscriberConfig);
            ScheduledExecutorService executor = Executors.newScheduledThreadPool(5, ModuleUtility.getNamedThreadFactory("delivery-subscriber-executor-%d"));
            binder.bind(ScheduledExecutorService.class).annotatedWith((Annotation)Names.named((String)"SUBSCRIBER_EXECUTOR")).toInstance((Object)executor);
            binder.install((Module)new SecureClientModule(this.subscriberConfig.getSslConfig()));
        } else {
            binder.install((Module)new SecureClientModule(null));
        }
        binder.install(new FactoryModuleBuilder().implement(IClient.class, TransportAwareClient.class).build(ClientFactory.class));
        binder.install((Module)new DefaultTransportModule());
        binder.install((Module)new DefaultRouterModule());
        binder.install(new FactoryModuleBuilder().implement(IRouter.class, TCPRouter.class).implement(ITransport.class, TCPTransport.class).build(CoreComponentFactory.class));
        binder.install(new FactoryModuleBuilder().build(ConcreteTransportFactory.class));
        binder.install(new FactoryModuleBuilder().build(ScopedSubscriberFactory.class));
        binder.install(new FactoryModuleBuilder().build(AuthenticationSupervisorFactory.class));
        binder.install(new FactoryModuleBuilder().build(DiscoverySupervisorFactory.class));
        binder.bind(ISubscriber.class).to(Subscriber.class).in(Singleton.class);
    }
}

