/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.subscriber;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jayeson.lib.delivery.module.ModuleUtility;
import jayeson.lib.delivery.module.subscriber.ScopedSubscriber;
import jayeson.lib.delivery.module.subscriber.ScopedSubscriberConfig;
import jayeson.lib.delivery.module.subscriber.StreamId;
import jayeson.lib.delivery.module.subscriber.StreamSource;
import jayeson.lib.delivery.module.subscriber.StreamState;
import jayeson.lib.streamfinder.Discoverer;
import jayeson.lib.streamfinder.DiscovererFactory;
import jayeson.lib.streamfinder.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoverySupervisor {
    private static Logger log = LoggerFactory.getLogger(DiscoverySupervisor.class);
    Discoverer discoverer;
    private ScopedSubscriber subscriber;
    private Map<StreamId, StreamSource> sourceStateMap;
    private List<String> excludedServices;

    @AssistedInject
    public DiscoverySupervisor(DiscovererFactory discovererFactory, @Assisted(value="scopeConfig") ScopedSubscriberConfig scopeConfig) {
        this(discovererFactory, scopeConfig, null);
    }

    @AssistedInject
    public DiscoverySupervisor(DiscovererFactory discovererFactory, @Assisted(value="scopeConfig") ScopedSubscriberConfig scopeConfig, @Assisted(value="scope") String scope) {
        this.discoverer = scope != null ? discovererFactory.create(scopeConfig.getSfConfig(), scope) : discovererFactory.create(scopeConfig.getSfConfig());
        this.discoverer.with("tcp").with("ssl");
        for (String group : scopeConfig.getDiscoveryStreams().keySet()) {
            List<String> streamsToBeDiscovered = scopeConfig.getDiscoveryStreams().get(group);
            for (String stream : streamsToBeDiscovered) {
                this.discoverer.discover(ModuleUtility.getByte(group).byteValue(), stream);
            }
        }
        this.sourceStateMap = new ConcurrentHashMap<StreamId, StreamSource>();
        this.excludedServices = new ArrayList<String>();
    }

    public void start() {
        this.discoverer.onUpdate(this::actOnDiscovery);
        this.discoverer.start();
    }

    public void stop() {
        try {
            this.discoverer.shutdown();
        }
        catch (IOException exp) {
            log.error("Exception shutting down discoverer ", (Throwable)exp);
        }
    }

    protected synchronized void actOnDiscovery(List<Source> sourceList) {
        for (StreamId consumingId : this.sourceStateMap.keySet()) {
            boolean isPresent = false;
            for (Source s : sourceList) {
                StreamId newStream = new StreamId(s.getGroup(), s.getStreamName());
                if (!consumingId.equals(newStream)) continue;
                isPresent = true;
                break;
            }
            StreamSource s = this.sourceStateMap.get(consumingId);
            if (isPresent) continue;
            log.info("Stream {} {} {} {} {} is not present in new discovery result. Stopping consumption", new Object[]{ModuleUtility.getString(s.group), s.stream, s.level, s.uri.toString(), s.serviceId});
            this.removeStreamFromConsumption(consumingId);
            this.subscriber.deActivateStream(consumingId);
        }
        for (Source s : sourceList) {
            log.info("Discoverer returned {} {} {} {} {}", new Object[]{ModuleUtility.getString(s.getGroup()), s.getStreamName(), s.getLevel(), s.getConnection().toString(), s.getServiceId()});
            StreamSource newSourceId = new StreamSource(s);
            if (this.isStreamConsumed(newSourceId.serviceId, newSourceId.streamId) && !this.subscriber.getConnectionStrategy().isBetterSource(this.sourceStateMap, newSourceId)) {
                log.info("Stream is already being consumed. Not taking any action");
                continue;
            }
            log.info("Connecting to stream {} {} {} {} {}", new Object[]{ModuleUtility.getString(s.getGroup()), s.getStreamName(), s.getLevel(), s.getConnection().toString(), s.getServiceId()});
            this.subscriber.connectAndConsumeSource(newSourceId);
            StreamSource sucessfulSource = new StreamSource(s);
            this.sourceStateMap.put(sucessfulSource.streamId, sucessfulSource);
        }
    }

    private boolean isStreamConsumed(String serviceId, StreamId streamId) {
        StreamSource availableSource = this.sourceStateMap.get(streamId);
        if (availableSource == null) {
            return false;
        }
        if (StreamState.DISCONTINUED.equals((Object)availableSource.streamState) && !serviceId.equals(availableSource.serviceId)) {
            return false;
        }
        return availableSource.serviceId.equals(serviceId);
    }

    public ScopedSubscriber getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(ScopedSubscriber subscriber) {
        this.subscriber = subscriber;
    }

    public void exclude(String serviceId) {
        for (StreamSource source : this.sourceStateMap.values()) {
            if (!source.serviceId.equals(serviceId)) continue;
            source.streamState = StreamState.DISCONTINUED;
        }
        this.discoverer.excluding(serviceId);
        this.excludedServices.add(serviceId);
        log.info("Excluding {}", (Object)serviceId);
        log.info("Checking last discovery result to see any new Sources");
        this.actOnDiscovery(this.discoverer.getSources());
    }

    void markStreamAsDiscontinued(StreamId streamId) {
        StreamSource availableSource = this.sourceStateMap.get(streamId);
        if (availableSource != null) {
            availableSource.streamState = StreamState.DISCONTINUED;
        }
        this.actOnDiscovery(this.discoverer.getSources());
    }

    void markStreamContinued(StreamId streamId) {
        StreamSource availableSource = this.sourceStateMap.get(streamId);
        if (availableSource != null) {
            availableSource.streamState = StreamState.CONSUMING;
        }
    }

    void removeStreamFromConsumption(StreamId streamId) {
        this.sourceStateMap.remove(streamId);
    }

    public void include(String serviceId) {
        log.info("Removing exclusion {}", (Object)serviceId);
        this.discoverer.removeExclusion(serviceId);
        for (StreamSource source : this.sourceStateMap.values()) {
            if (!source.serviceId.equals(serviceId)) continue;
            source.streamState = StreamState.CONSUMING;
        }
        this.excludedServices.remove(serviceId);
    }

    public boolean isExcluded(String serviceId) {
        return this.excludedServices.contains(serviceId);
    }
}

