/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.subscriber;

import com.google.inject.Inject;
import java.util.Set;
import jayeson.lib.delivery.module.subscriber.ConnectionInfo;
import jayeson.lib.delivery.module.subscriber.ConnectionSupervisor;
import jayeson.lib.delivery.module.subscriber.SubscriberConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnectClientTask
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(ReconnectClientTask.class);
    long checkIntervalMs = 2000L;
    private SubscriberConfig subConfig;
    private ConnectionSupervisor connectionSupervisor;

    @Override
    public void run() {
        try {
            Set<ConnectionInfo> disconnectedClients = this.connectionSupervisor.getDisconnectedClients();
            for (ConnectionInfo connectionInfo : disconnectedClients) {
                if (connectionInfo.getRetryCount() >= this.subConfig.getReconnectCount()) {
                    this.connectionSupervisor.handleReconnectionFail(connectionInfo);
                }
                if (System.currentTimeMillis() - connectionInfo.getLastConnectionTimeMs() < this.subConfig.getAutoReconnectIntervalMs()) continue;
                this.connectionSupervisor.connectClient(connectionInfo);
            }
        }
        catch (Exception ex) {
            log.error("Error in ReconnectClientTask", (Throwable)ex);
        }
    }

    public ConnectionSupervisor getConnectionSupervisor() {
        return this.connectionSupervisor;
    }

    public void setConnectionSupervisor(ConnectionSupervisor connectionSupervisor) {
        this.connectionSupervisor = connectionSupervisor;
    }

    public SubscriberConfig getSubConfig() {
        return this.subConfig;
    }

    @Inject
    public void setSubConfig(SubscriberConfig subConfig) {
        this.subConfig = subConfig;
    }

    public long getCheckIntervalMs() {
        return this.checkIntervalMs;
    }

    public void setCheckIntervalMs(long checkIntervalMs) {
        this.checkIntervalMs = checkIntervalMs;
    }
}

