/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.subscriber;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import jayeson.lib.delivery.api.IClient;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.IEndPointEventSource;
import jayeson.lib.delivery.api.IEndPointListener;
import jayeson.lib.delivery.api.events.EPConnectedEvent;
import jayeson.lib.delivery.api.events.EPDisconnectedEvent;
import jayeson.lib.delivery.api.events.EPEvent;
import jayeson.lib.delivery.api.events.IEPEventDispatcher;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.module.ModuleUtility;
import jayeson.lib.delivery.module.auth.messages.beans.GeneralResponse;
import jayeson.lib.delivery.module.streamregistry.messages.StreamRegistryResponse;
import jayeson.lib.delivery.module.subscriber.AuthenticationSupervisor;
import jayeson.lib.delivery.module.subscriber.AuthenticationSupervisorFactory;
import jayeson.lib.delivery.module.subscriber.ConnectionState;
import jayeson.lib.delivery.module.subscriber.ConnectionStrategy;
import jayeson.lib.delivery.module.subscriber.ConnectionSupervisor;
import jayeson.lib.delivery.module.subscriber.DiscoverySupervisor;
import jayeson.lib.delivery.module.subscriber.DiscoverySupervisorFactory;
import jayeson.lib.delivery.module.subscriber.ISubscriber;
import jayeson.lib.delivery.module.subscriber.ScopedSubscriberConfig;
import jayeson.lib.delivery.module.subscriber.StreamId;
import jayeson.lib.delivery.module.subscriber.StreamSource;
import jayeson.lib.delivery.module.subscriber.StreamState;
import jayeson.lib.delivery.module.subscriber.SubscriberAuthGroupProcessor;
import jayeson.lib.delivery.module.subscriber.SubscriberConfig;
import jayeson.lib.delivery.module.subscriber.SubscriberStreamRegistryGroupProcessor;
import jayeson.lib.delivery.module.subscriber.events.ConsumptionErrorEvent;
import jayeson.lib.delivery.module.subscriber.events.ConsumptionStartEvent;
import jayeson.lib.delivery.module.subscriber.events.ConsumptionStopEvent;
import jayeson.lib.streamfinder.SessionToken;
import jayeson.lib.streamfinder.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopedSubscriber
implements ISubscriber,
IEndPointListener,
IEndPointEventSource {
    private static Logger log = LoggerFactory.getLogger(ScopedSubscriber.class);
    private Map<IMessageGroup, IMessageGroupProcessor> messageGroupProcessors = new HashMap<IMessageGroup, IMessageGroupProcessor>();
    private SubscriberAuthGroupProcessor authGroupProcessor;
    private SubscriberStreamRegistryGroupProcessor streamRegistryGroupProcessor;
    private Map<Byte, List<CompletableFuture<Void>>> streamRegistrationFutures;
    private ConnectionSupervisor connectionSupervisor;
    private AuthenticationSupervisor authSupervisor;
    private DiscoverySupervisor discoverySupervisor;
    private ConnectionStrategy connectionStrategy;
    public static final String SUBSCRIBER_EXECUTOR = "SUBSCRIBER_EXECUTOR";
    private ScheduledExecutorService executorService;
    private Map<StreamId, StreamSource> activeSources = new ConcurrentHashMap<StreamId, StreamSource>();
    private Map<StreamId, StreamSource> waitingSources = new HashMap<StreamId, StreamSource>();
    private SubscriberConfig subscriberConfig;
    private Object objectLock;
    private IEPEventDispatcher eventDispatcher;
    private final String scope;
    private boolean isStopped;

    @AssistedInject
    public ScopedSubscriber(SubscriberAuthGroupProcessor authGroupProcessor, SubscriberStreamRegistryGroupProcessor streamRegistryGroupProcessor, DiscoverySupervisorFactory discoverySupervisorFactory, AuthenticationSupervisorFactory authSupervisorFactory, ConnectionSupervisor connectionSupervisor, SubscriberConfig subscriberConfig, @Named(value="SUBSCRIBER_EXECUTOR") ScheduledExecutorService executorService) {
        this(authGroupProcessor, streamRegistryGroupProcessor, discoverySupervisorFactory, authSupervisorFactory, connectionSupervisor, null, subscriberConfig, executorService);
    }

    @AssistedInject
    public ScopedSubscriber(SubscriberAuthGroupProcessor authGroupProcessor, SubscriberStreamRegistryGroupProcessor streamRegistryGroupProcessor, DiscoverySupervisorFactory discoverySupervisorFactory, AuthenticationSupervisorFactory authSupervisorFactory, ConnectionSupervisor connectionSupervisor, @Assisted(value="scope") String scope, SubscriberConfig subscriberConfig, @Named(value="SUBSCRIBER_EXECUTOR") ScheduledExecutorService executorService) {
        this.authGroupProcessor = authGroupProcessor;
        this.authGroupProcessor.setSubscriber(this);
        this.streamRegistryGroupProcessor = streamRegistryGroupProcessor;
        this.streamRegistryGroupProcessor.setSubscriber(this);
        ScopedSubscriberConfig scopedConf = subscriberConfig.getScopes().get(scope);
        this.authSupervisor = authSupervisorFactory.create(scopedConf);
        this.authSupervisor.setSubscriber(this);
        this.discoverySupervisor = scope != null ? discoverySupervisorFactory.create(scopedConf, scope) : discoverySupervisorFactory.create(scopedConf);
        this.discoverySupervisor.setSubscriber(this);
        this.connectionSupervisor = connectionSupervisor;
        this.connectionSupervisor.setSubscriber(this);
        this.connectionStrategy = ConnectionStrategy.LEVEL_OPTIMISED_CONNECTION_STRATEGY;
        this.objectLock = new Object();
        this.scope = scope;
        this.subscriberConfig = subscriberConfig;
        this.streamRegistrationFutures = new ConcurrentHashMap<Byte, List<CompletableFuture<Void>>>();
        this.executorService = executorService;
    }

    @Override
    public void startConsuming() {
        if (this.isStopped) {
            throw new IllegalStateException("Cannot start a previously stopped subscriber");
        }
        this.authSupervisor.start();
        this.discoverySupervisor.start();
        this.connectionSupervisor.start();
    }

    @Override
    public void stopConsuming() {
        this.isStopped = true;
        this.connectionSupervisor.stop();
        this.discoverySupervisor.stop();
        this.authSupervisor.stop();
    }

    private Set<StreamSource> _getSourcesToBeRegistered(IEndPoint ep) {
        String serviceId = this.connectionSupervisor.getServiceId(ep);
        HashSet<StreamSource> sourcesToBeRegistered = new HashSet<StreamSource>();
        for (StreamId streamId : this.activeSources.keySet()) {
            StreamSource streamSource = this.activeSources.get(streamId);
            if (!streamSource.serviceId.equals(serviceId) || !streamSource.isWaitingToBeRegistered()) continue;
            sourcesToBeRegistered.add(streamSource);
        }
        return sourcesToBeRegistered;
    }

    private void _markSourcesAs(IEndPoint ep, StreamState streamState) {
        String serviceId = this.connectionSupervisor.getServiceId(ep);
        for (StreamSource streamSource : this.activeSources.values()) {
            if (!streamSource.serviceId.equals(serviceId)) continue;
            this.annotateStream(streamSource, streamState);
        }
    }

    private Set<StreamSource> _getAllSources(IEndPoint ep) {
        String serviceId = this.connectionSupervisor.getServiceId(ep);
        return this._getAllSources(serviceId);
    }

    private Set<StreamSource> _getAllSources(String serviceId) {
        HashSet<StreamSource> returnSet = new HashSet<StreamSource>();
        for (StreamSource streamSource : this.activeSources.values()) {
            if (!streamSource.serviceId.equals(serviceId)) continue;
            returnSet.add(streamSource);
        }
        return returnSet;
    }

    @Override
    public void attachMessageGroupProcessor(IMessageGroupProcessor m) {
        log.trace("Attaching MessageGroupProcessor {} for group {}", m.getClass(), (Object)m.messageGroup());
        this.messageGroupProcessors.put(m.messageGroup(), m);
        Byte messageGroupId = m.messageGroup().id();
        if (this.streamRegistrationFutures.containsKey(messageGroupId)) {
            this.streamRegistrationFutures.get(messageGroupId).stream().forEach(completableFuture -> completableFuture.complete(null));
            this.streamRegistrationFutures.remove(messageGroupId);
        }
    }

    @Override
    public void detachMessageGroupProcessor(IMessageGroupProcessor m) {
        Byte messageGroupId;
        if (this.messageGroupProcessors.get(m.messageGroup()) == m) {
            log.trace("Detaching MessageGroupProcessor {} for group {}", m.getClass(), (Object)m.messageGroup());
            this.messageGroupProcessors.remove(m.messageGroup());
        }
        if (this.streamRegistrationFutures.containsKey(messageGroupId = Byte.valueOf(m.messageGroup().id()))) {
            this.streamRegistrationFutures.remove(messageGroupId);
        }
    }

    protected boolean isTicketAvailable() {
        return this.authSupervisor.getSessionToken() != null && this.authSupervisor.getTicket() != null;
    }

    public void connectAndConsumeSource(StreamSource availableSource) {
        StreamId streamId = availableSource.streamId;
        StreamSource usingSource = this.activeSources.get(streamId);
        if (usingSource != null) {
            if (usingSource.streamState.isActive()) {
                if (usingSource.streamState != StreamState.DEREGISTERING) {
                    this.deActivateSource(usingSource);
                    this.executorService.schedule(() -> {
                        if (usingSource.streamState == StreamState.DEREGISTERING) {
                            IClient client = this.connectionSupervisor.getClient(usingSource.serviceId);
                            IEndPoint endpoint = client.getEndPoint();
                            log.warn("Timeout waiting for deregistration response, proceeding to treat stream {}:{} as deregistered for {}", new Object[]{usingSource.group, usingSource.stream, endpoint.getIdentifier()});
                            this.postStreamDeregistration(endpoint, usingSource);
                        }
                    }, 7000L, TimeUnit.MILLISECONDS);
                }
                this.waitingSources.put(streamId, availableSource);
            } else {
                this.activeSources.put(streamId, availableSource);
                this.activateSource(availableSource);
            }
        } else {
            this.activeSources.put(streamId, availableSource);
            this.activateSource(availableSource);
        }
    }

    private void deActivateSource(StreamSource source) {
        log.info("Deactivating source: {}", (Object)source.uri);
        if (!source.streamState.isRegistered()) {
            source.abortProtocol = true;
        } else {
            IClient client = this.connectionSupervisor.getClient(source.serviceId);
            this.annotateStream(source, StreamState.DEREGISTERING);
            this.streamRegistryGroupProcessor.deRegisterStream(client.getEndPoint(), source.streamId);
        }
    }

    void deActivateStream(StreamId streamId) {
        StreamSource usingSource = this.activeSources.get(streamId);
        if (usingSource != null) {
            this.deActivateSource(usingSource);
        }
    }

    private void activateSource(StreamSource source) {
        this.annotateStream(source, StreamState.WAITING);
        if (this.connectionSupervisor.hasActiveConnection(source.serviceId)) {
            ConnectionState connectionState = this.connectionSupervisor.getConnectionState(source.serviceId);
            if (ConnectionState.isAuthenticationDone(connectionState)) {
                this.annotateStream(source, StreamState.REGISTERING);
                IEndPoint ep = this.connectionSupervisor.getClient(source.serviceId).getEndPoint();
                this.streamRegistryGroupProcessor.registerStream(ep, source.streamId);
            }
        } else {
            this.connectionSupervisor.connectToSource(source, this);
        }
    }

    protected void actOnAuthenticationResponse(IEndPoint endpoint, GeneralResponse response) {
        if (response.getMessage().contains("Ticket Renew")) {
            this.actOnTicketResposne(endpoint, response);
            return;
        }
        log.info("Received Authentication Response {} {} from {}", new Object[]{response.getStatus(), response.getMessage(), endpoint.getIdentifier()});
        if (response.getStatus() == 0) {
            this.connectionSupervisor.annotateClient(endpoint, ConnectionState.AUTHENTICATED);
            Set<StreamSource> sourcesToBeRegistered = this._getSourcesToBeRegistered(endpoint);
            for (StreamSource streamSource : sourcesToBeRegistered) {
                this.annotateStream(streamSource, StreamState.REGISTERING);
                this.streamRegistryGroupProcessor.registerStream(endpoint, streamSource.streamId);
            }
            endpoint.registerGroupProcessor(this.streamRegistryGroupProcessor.messageGroup(), this.streamRegistryGroupProcessor);
        } else {
            this.connectionSupervisor.annotateClient(endpoint, ConnectionState.WAITING);
            this._markSourcesAs(endpoint, StreamState.WAITING);
        }
        String serviceId = this.connectionSupervisor.getServiceId(endpoint);
        this.checkForAbortedSources(serviceId);
    }

    protected void actOnTicketResposne(IEndPoint endpoint, GeneralResponse response) {
        log.info("Received TicketRenew Response with status {},message {} from {} ", new Object[]{response.getStatus(), response.getMessage(), endpoint.getIdentifier()});
    }

    protected void processRegistrationResponse(IEndPoint endpoint, StreamRegistryResponse response) {
        for (IMessageGroupProcessor messageGroupProcessor : this.messageGroupProcessors.values()) {
            if (messageGroupProcessor.messageGroup().id() != response.getMessageGroup().byteValue()) continue;
            endpoint.registerGroupProcessor(messageGroupProcessor.messageGroup(), messageGroupProcessor);
        }
        if (!ModuleUtility.isNullOrEmpty(response.getStreams())) {
            for (String stream : response.getStreams().keySet()) {
                StreamSource source = this._getCurrentSource(response.getMessageGroup(), stream);
                if (source.abortProtocol) {
                    this.cleanUpAbortedSources(source);
                    continue;
                }
                if (response.getStreams().get(stream) == 4) {
                    log.info("Sending StreamConsumptionRequest for Group: {} Stream: {}", (Object)response.getMessageGroup(), (Object)stream);
                    this.annotateStream(source, StreamState.REGISTERED);
                    this.streamRegistryGroupProcessor.consumeStream(endpoint, source.streamId);
                    this.discoverySupervisor.markStreamContinued(source.streamId);
                    this.eventDispatcher.dispatchEvent(new ConsumptionStartEvent(endpoint, source.streamId, this.scope));
                    continue;
                }
                log.info("StreamRegistrationResponse Failed for {} {}", (Object)response.getMessageGroup(), (Object)stream);
                this.executorService.schedule(() -> this.streamRegistryGroupProcessor.registerStream(endpoint, source.streamId), 1000L, TimeUnit.MILLISECONDS);
                this.discoverySupervisor.markStreamAsDiscontinued(source.streamId);
                this.eventDispatcher.dispatchEvent(new ConsumptionErrorEvent(endpoint, source.streamId, this.scope));
            }
        }
    }

    protected boolean isGroupProcessorRegistered(Byte messageGroupId) {
        for (IMessageGroupProcessor messageGroupProcessor : this.messageGroupProcessors.values()) {
            if (messageGroupProcessor.messageGroup().id() != messageGroupId.byteValue()) continue;
            return true;
        }
        return false;
    }

    public void actOnStreamRegistryResponse(IEndPoint endpoint, StreamRegistryResponse response) {
        log.info("Received StreamRegistryResponse of type {} from {}", (Object)response.getResponseType(), (Object)endpoint.getIdentifier());
        if (response.getComment() != null) {
            log.info("Comment: {}", (Object)response.getComment());
        }
        log.info("StreamRegistryResponse belongs to Group: {} Streams: {}", (Object)response.getMessageGroup(), (Object)response.getStreams().toString());
        if (response.getResponseType() == 0) {
            if (this.isGroupProcessorRegistered(response.getMessageGroup())) {
                this.processRegistrationResponse(endpoint, response);
            } else {
                CompletableFuture cf = new CompletableFuture();
                cf.thenRun(() -> this.processRegistrationResponse(endpoint, response));
                List futuresList = this.streamRegistrationFutures.computeIfAbsent(response.getMessageGroup(), msgGroupId -> new ArrayList());
                futuresList.add(cf);
            }
        } else if (response.getResponseType() == 1) {
            if (!ModuleUtility.isNullOrEmpty(response.getStreams())) {
                for (String stream : response.getStreams().keySet()) {
                    StreamSource source = this._getCurrentSource(response.getMessageGroup(), stream);
                    if (source.abortProtocol) continue;
                    if (response.getStreams().get(stream) == 4) {
                        log.info("Consuming Group: {} Stream: {}", (Object)response.getMessageGroup(), (Object)stream);
                        this.annotateStream(source, StreamState.CONSUMING);
                        continue;
                    }
                    log.info("StreamConsumptionResponse Failed for {} {}", (Object)response.getMessageGroup(), (Object)stream);
                    this.annotateStream(source, StreamState.DISCONTINUED);
                    this.discoverySupervisor.markStreamAsDiscontinued(source.streamId);
                    this.eventDispatcher.dispatchEvent(new ConsumptionErrorEvent(endpoint, source.streamId, this.scope));
                }
            }
        } else if (response.getResponseType() == 2) {
            if (!ModuleUtility.isNullOrEmpty(response.getStreams())) {
                for (String stream : response.getStreams().keySet()) {
                    StreamSource source = this._getCurrentSource(response.getMessageGroup(), stream);
                    if (response.getStreams().get(stream) == 4) {
                        log.info("StreamDeRegistrationSuccess for {} {}", (Object)response.getMessageGroup(), (Object)stream);
                        this.postStreamDeregistration(endpoint, source);
                        continue;
                    }
                    log.info("StreamDeRegistrationFail for {} {}", (Object)response.getMessageGroup(), (Object)stream);
                }
            }
        } else if (response.getResponseType() == 6) {
            if (!ModuleUtility.isNullOrEmpty(response.getStreams())) {
                for (String stream : response.getStreams().keySet()) {
                    StreamSource source = this._getCurrentSource(response.getMessageGroup(), stream);
                    if (source.abortProtocol) {
                        this.cleanUpAbortedSources(source);
                        continue;
                    }
                    log.info("Received Stop Stream Consumption from {} {}", (Object)response.getMessageGroup(), (Object)stream);
                    this.annotateStream(source, StreamState.REGISTERING);
                    this.executorService.schedule(() -> this.streamRegistryGroupProcessor.registerStream(endpoint, source.streamId), 1000L, TimeUnit.MILLISECONDS);
                    this.discoverySupervisor.markStreamAsDiscontinued(source.streamId);
                    this.eventDispatcher.dispatchEvent(new ConsumptionErrorEvent(endpoint, source.streamId, this.scope));
                }
            }
        } else if (response.getResponseType() == 3) {
            log.info("{} {}", (Object)response.getMessageGroup(), response.getStreams());
        }
    }

    public void postStreamDeregistration(IEndPoint endpoint, StreamSource source) {
        this.annotateStream(source, StreamState.DEREGISTERED);
        this.eventDispatcher.dispatchEvent(new ConsumptionStopEvent(endpoint, source.streamId, this.scope));
        this.cleanUpAbortedSources(source);
    }

    private StreamSource _getCurrentSource(Byte group, String stream) {
        StreamId streamId = new StreamId(group, stream);
        return this.activeSources.get(streamId);
    }

    protected void actOnSessionToken(SessionToken sessionToken) {
        log.info("New sessiontoken generated accesstoken-{},cookie-{},sessionid-{},error-{}", new Object[]{sessionToken.getAccessToken(), sessionToken.getCookie(), sessionToken.getSessionId(), sessionToken.getError()});
    }

    protected void actOnTicket(String ticket) {
        log.info("New ticket generated {}", (Object)ticket);
        this.connectionSupervisor.connectWaitingClients();
        Set<IClient> authenticatedClients = this.connectionSupervisor.getAuthenticatedClients();
        for (IClient client : authenticatedClients) {
            this.authGroupProcessor.sendTicket(client.getEndPoint(), this.authSupervisor.getClientId(), this.authSupervisor.getTicket());
        }
    }

    @Override
    public void onEvent(EPEvent event) {
        if (event instanceof EPConnectedEvent) {
            this.connectionSupervisor.annotateClient(event.getEndpoint(), ConnectionState.CONNECTED);
            this.connectionSupervisor.annotateClient(event.getEndpoint(), ConnectionState.AUTHENTICATING);
            event.getEndpoint().registerGroupProcessor(this.authGroupProcessor.messageGroup(), this.authGroupProcessor);
            this.authGroupProcessor.sendAuthContent(event.getEndpoint(), this.authSupervisor.getClientId(), this.authSupervisor.getSessionToken(), this.authSupervisor.getTicket(), this.scope);
        }
        if (event instanceof EPDisconnectedEvent) {
            this._markSourcesAs(event.getEndpoint(), StreamState.WAITING);
            this.connectionSupervisor.annotateClient(event.getEndpoint(), ConnectionState.DISCONNECTED);
            Set<StreamSource> sources = this._getAllSources(event.getEndpoint());
            HashSet<StreamId> streamIdSet = new HashSet<StreamId>();
            for (StreamSource source : sources) {
                streamIdSet.add(source.streamId);
            }
            if (!streamIdSet.isEmpty()) {
                this.eventDispatcher.dispatchEvent(new ConsumptionErrorEvent(event.getEndpoint(), streamIdSet, this.scope));
            }
            this.authGroupProcessor.dropState(event.getEndpoint());
            this.streamRegistryGroupProcessor.dropState(event.getEndpoint());
        }
    }

    private void cleanUpAbortedSources(StreamSource s) {
        log.debug("Removing Stream {} for source {}:{}", new Object[]{s.streamId.getIdentifier(), s.uri.getHost(), s.uri.getPort()});
        StreamSource obsoleteSource = this.activeSources.remove(s.streamId);
        StreamSource waitingSource = this.waitingSources.get(s.streamId);
        if (waitingSource != null) {
            log.debug("Adding Stream {} for source {}-{}", new Object[]{waitingSource.streamId.getIdentifier(), waitingSource.uri.getHost(), waitingSource.uri.getPort()});
            this.activeSources.put(waitingSource.streamId, waitingSource);
            this.activateSource(waitingSource);
        }
        this.waitingSources.remove(s.streamId);
        Set<StreamSource> sourcesOfServiceId = this._getAllSources(obsoleteSource.serviceId);
        if (sourcesOfServiceId.isEmpty()) {
            this.connectionSupervisor.disconnectSource(obsoleteSource.serviceId);
            this.discoverySupervisor.include(obsoleteSource.serviceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotateStream(StreamSource source, StreamState streamState) {
        Object object = this.objectLock;
        synchronized (object) {
            source.streamState = streamState;
        }
    }

    @Override
    public Set<Source> getStreams() {
        HashSet<Source> returnSet = new HashSet<Source>();
        for (StreamSource source : this.activeSources.values()) {
            returnSet.add(new Source(source.group.byteValue(), source.stream, source.level, source.serviceId, source.uri));
        }
        return returnSet;
    }

    public ConnectionSupervisor getConnectionSupervisor() {
        return this.connectionSupervisor;
    }

    void setConnectionSupervisor(ConnectionSupervisor connectionSupervisor) {
        this.connectionSupervisor = connectionSupervisor;
    }

    public SubscriberAuthGroupProcessor getAuthGroupProcessor() {
        return this.authGroupProcessor;
    }

    public void setAuthGroupProcessor(SubscriberAuthGroupProcessor authGroupProcessor) {
        this.authGroupProcessor = authGroupProcessor;
    }

    public SubscriberStreamRegistryGroupProcessor getStreamRegistryGroupProcessor() {
        return this.streamRegistryGroupProcessor;
    }

    public void setStreamRegistryGroupProcessor(SubscriberStreamRegistryGroupProcessor streamRegistryGroupProcessor) {
        this.streamRegistryGroupProcessor = streamRegistryGroupProcessor;
    }

    public SubscriberConfig getSubscriberConfig() {
        return this.subscriberConfig;
    }

    public ConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public void setConnectionStrategy(ConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    public DiscoverySupervisor getDiscoverySupervisor() {
        return this.discoverySupervisor;
    }

    public void setDiscoverySupervisor(DiscoverySupervisor discoverySupervisor) {
        this.discoverySupervisor = discoverySupervisor;
    }

    public AuthenticationSupervisor getAuthSupervisor() {
        return this.authSupervisor;
    }

    public void setAuthSupervisor(AuthenticationSupervisor authSupervisor) {
        this.authSupervisor = authSupervisor;
    }

    protected Map<StreamId, StreamSource> getActiveSources() {
        return this.activeSources;
    }

    protected void setActiveSources(Map<StreamId, StreamSource> activeSources) {
        this.activeSources = activeSources;
    }

    protected Map<StreamId, StreamSource> getWaitingSources() {
        return this.waitingSources;
    }

    protected void setWaitingSources(Map<StreamId, StreamSource> waitingSources) {
        this.waitingSources = waitingSources;
    }

    public void handleReconnectionFail(String serviceId) {
        if (!this.discoverySupervisor.isExcluded(serviceId)) {
            this.discoverySupervisor.exclude(serviceId);
            Set<StreamSource> sources = this._getAllSources(serviceId);
            HashSet<StreamId> streamIdSet = new HashSet<StreamId>();
            for (StreamSource source : sources) {
                streamIdSet.add(source.streamId);
            }
            if (!streamIdSet.isEmpty()) {
                this.eventDispatcher.dispatchEvent(new ConsumptionErrorEvent(null, streamIdSet, this.scope));
            }
        }
    }

    protected void checkForAbortedSources(String serviceId) {
        Set<StreamSource> allSources = this._getAllSources(serviceId);
        for (StreamSource source : allSources) {
            if (!source.abortProtocol) continue;
            this.cleanUpAbortedSources(source);
        }
        if (ConnectionState.isConnected(this.connectionSupervisor.getConnectionState(serviceId))) {
            this.discoverySupervisor.include(serviceId);
        }
    }

    @Override
    public void attachListener(IEndPointListener listener) {
        this.eventDispatcher.registerListener(listener);
    }

    @Override
    public void detachListener(IEndPointListener listener) {
        this.eventDispatcher.deregisterListener(listener);
    }

    public IEPEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    @Inject
    public void setEventDispatcher(IEPEventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }
}

