/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.subscriber;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jayeson.lib.delivery.api.IEndPointListener;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.module.subscriber.ISubscriber;
import jayeson.lib.delivery.module.subscriber.ScopedSubscriber;
import jayeson.lib.delivery.module.subscriber.ScopedSubscriberConfig;
import jayeson.lib.delivery.module.subscriber.ScopedSubscriberFactory;
import jayeson.lib.delivery.module.subscriber.SubscriberConfig;
import jayeson.lib.streamfinder.Source;

public class Subscriber
implements ISubscriber {
    List<ScopedSubscriber> scopedSubscribers = new ArrayList<ScopedSubscriber>();

    @Inject
    public Subscriber(ScopedSubscriberFactory subsFactory, SubscriberConfig config) {
        for (Map.Entry<String, ScopedSubscriberConfig> it : config.getScopes().entrySet()) {
            String scope = it.getKey();
            ScopedSubscriberConfig scopedConfig = it.getValue();
            if (scopedConfig.getDiscoveryStreams().isEmpty()) continue;
            this.scopedSubscribers.add(subsFactory.create(scope));
        }
    }

    @Override
    public void attachListener(IEndPointListener listener) {
        this.scopedSubscribers.stream().forEach(subs -> subs.attachListener(listener));
    }

    @Override
    public void detachListener(IEndPointListener listener) {
        this.scopedSubscribers.stream().forEach(subs -> subs.detachListener(listener));
    }

    @Override
    public void startConsuming() {
        this.scopedSubscribers.stream().forEach(ScopedSubscriber::startConsuming);
    }

    @Override
    public void stopConsuming() {
        this.scopedSubscribers.stream().forEach(ScopedSubscriber::stopConsuming);
    }

    @Override
    public void attachMessageGroupProcessor(IMessageGroupProcessor messageGroupParser) {
        this.scopedSubscribers.stream().forEach(subs -> subs.attachMessageGroupProcessor(messageGroupParser));
    }

    @Override
    public void detachMessageGroupProcessor(IMessageGroupProcessor messageGroupParser) {
        this.scopedSubscribers.stream().forEach(subs -> subs.detachMessageGroupProcessor(messageGroupParser));
    }

    @Override
    public Set<Source> getStreams() {
        return this.scopedSubscribers.stream().map(ScopedSubscriber::getStreams).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

