/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.subscriber;

import com.google.inject.Inject;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.EndPoint;
import jayeson.lib.delivery.module.auth.messages.AuthGroup;
import jayeson.lib.delivery.module.auth.messages.beans.AuthContent;
import jayeson.lib.delivery.module.auth.messages.beans.GeneralResponse;
import jayeson.lib.delivery.module.auth.messages.beans.TicketRenew;
import jayeson.lib.delivery.module.subscriber.ScopedSubscriber;
import jayeson.lib.streamfinder.SessionToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriberAuthGroupProcessor
implements IMessageGroupProcessor {
    private static Logger log = LoggerFactory.getLogger(SubscriberAuthGroupProcessor.class);
    @Inject
    private AuthGroup authGroup;
    private ScopedSubscriber subscriber;

    @Override
    public void process(MessageWrapper mw) {
        if (mw == null) {
            log.equals("Fatal.MessageWrapper is null");
            return;
        }
        Object rawMsg = mw.msg();
        if (rawMsg == null) {
            log.error("Raw message is null for MessageClass {} ", mw.getMessageClass());
            return;
        }
        if (!(rawMsg instanceof GeneralResponse)) {
            log.error("SubscriberAuthGroupProcessor is expecting only GeneralResponse.but Received{} {}.EndPoint {}", new Object[]{rawMsg.getClass(), rawMsg.toString(), mw.getEndpoint().getIdentifier()});
            return;
        }
        GeneralResponse generalResponse = (GeneralResponse)rawMsg;
        this.subscriber.actOnAuthenticationResponse(mw.getEndpoint(), generalResponse);
    }

    protected void sendAuthContent(IEndPoint ep, String clientId, SessionToken sessionToken, String ticket, String feedScope) {
        AuthContent authContent = new AuthContent();
        authContent.setClientId(clientId);
        authContent.setTicket(ticket);
        authContent.setSessionData(sessionToken.getCookie());
        authContent.setClientId(clientId);
        authContent.setFeedScope(feedScope);
        MessageWrapper mw = new MessageWrapper(authContent, this.authGroup.classById((byte)2));
        try {
            ep.send(mw);
        }
        catch (Exception e) {
            log.error("Error Sending AuthContent Message to EndPoint{} {}", (Object)ep.getIdentifier(), (Object)e);
        }
    }

    protected void sendTicket(IEndPoint ep, String clientId, String ticket) {
        TicketRenew renew = new TicketRenew();
        renew.setClientId(clientId);
        renew.setNewTicket(ticket);
        try {
            if (ep instanceof EndPoint) {
                log.debug("Sending new ticket to {}", (Object)ep.getIdentifier());
                ((EndPoint)ep).send(new MessageWrapper(renew, this.authGroup.classById((byte)3)), this.getChannelFuture(ep.getIdentifier()));
            } else {
                log.debug("Sending new ticket to {}", (Object)ep.getIdentifier());
                ep.send(new MessageWrapper(renew, this.authGroup.classById((byte)3)));
            }
        }
        catch (Exception e) {
            log.error("Error While Sending Renew Ticket message to EndPoint {} ", (Object)ep.getIdentifier(), (Object)e);
        }
    }

    private ChannelFutureListener getChannelFuture(final String identifier) {
        return new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                log.debug("Sending of new ticket to {} successful? {}", (Object)identifier, (Object)future.isSuccess());
            }
        };
    }

    @Override
    public void onRegistered(IEndPoint endpoint) {
        log.info("Subscriber GroupProcessor is registered {}", (Object)endpoint.getIdentifier());
    }

    protected void dropState(IEndPoint ep) {
    }

    @Override
    public void onDeregistered(IEndPoint endpoint) {
        log.info("Subsiber GroupProcessor is deregistered {}", (Object)endpoint.getIdentifier());
    }

    @Override
    public IMessageGroup messageGroup() {
        return this.authGroup;
    }

    public ScopedSubscriber getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(ScopedSubscriber subscriber) {
        this.subscriber = subscriber;
    }
}

