/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.module.subscriber;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.netty.channel.Channel;
import io.netty.channel.socket.SocketChannel;
import jayeson.lib.delivery.api.ClientConfig;
import jayeson.lib.delivery.api.IRouter;
import jayeson.lib.delivery.api.ITransport;
import jayeson.lib.delivery.core.client.ClientEndPointMonitorFactory;
import jayeson.lib.delivery.core.client.DefaultClient;
import jayeson.lib.delivery.module.subscriber.ConcreteTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportAwareClient
extends DefaultClient {
    private static Logger log = LoggerFactory.getLogger(TransportAwareClient.class);
    private String transportType;
    private ConcreteTransportFactory concreteTransportFactory;

    @Inject
    public TransportAwareClient(@Assisted String transportType, ClientConfig clientConfig, ClientEndPointMonitorFactory CEPMF) {
        super(clientConfig, CEPMF);
        this.transportType = transportType;
    }

    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        IRouter router = this.ccFactory.createRouter((Channel)ch);
        ITransport transport = null;
        if ("ssl".equals(this.transportType)) {
            transport = this.concreteTransportFactory.createSSLTransport((Channel)ch);
        } else if ("tcp".equals(this.transportType)) {
            transport = this.concreteTransportFactory.createTCPTransport((Channel)ch);
        } else {
            log.info("Transport Type is neither tcp or ssl. Using Default binded transport");
            transport = this.ccFactory.createTransport((Channel)ch);
        }
        this.setupChannel(ch, router, transport);
    }

    public ConcreteTransportFactory getConcreteTransportFactory() {
        return this.concreteTransportFactory;
    }

    @Inject
    public void setConcreteTransportFactory(ConcreteTransportFactory concreteTransportFactory) {
        this.concreteTransportFactory = concreteTransportFactory;
    }
}

