/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.delivery;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.HashMap;
import java.util.Map;
import jayeson.lib.streamfinder.Advertiser;
import jayeson.lib.streamfinder.AdvertiserFactory;
import jayeson.lib.streamfinder.StreamfinderConfig;
import jayeson.service.delivery.AdvertConfig;
import jayeson.service.delivery.AdvertPredicate;
import jayeson.service.delivery.ScopeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AdvertMultiplexer {
    Map<AdvertPredicate, Advertiser> advertisers;
    final Logger log = LoggerFactory.getLogger(AdvertMultiplexer.class);

    @Inject
    public AdvertMultiplexer(ScopeConfig scopeConfig, AdvertiserFactory factory, @Named(value="ServiceId") String serviceId) {
        this.advertisers = new HashMap<AdvertPredicate, Advertiser>();
        scopeConfig.getScopes().forEach((scope, scopeEntry) -> {
            AdvertConfig advertConfig = scopeEntry.getAdMuxConfig();
            StreamfinderConfig sfConfig = scopeEntry.getSfConfig();
            AdvertPredicate predicate = new AdvertPredicate(advertConfig.getStreams());
            Advertiser advertiser = this.createAdvertiser(serviceId, sfConfig, advertConfig, (String)scope, factory);
            this.advertisers.put(predicate, advertiser);
        });
    }

    Advertiser createAdvertiser(String serviceId, StreamfinderConfig c, AdvertConfig muxConf, String scope, AdvertiserFactory factory) {
        c.setServiceId(serviceId);
        Advertiser adv = factory.create(c, scope);
        muxConf.getListenOn().stream().forEach(url -> adv.from(url));
        this.log.info("Created advertiser " + c.getUsername() + " " + serviceId);
        return adv;
    }

    public AdvertMultiplexer advertise(byte group, String stream, int level) {
        this.advertisers.entrySet().stream().filter(entry -> ((AdvertPredicate)entry.getKey()).test(group, stream)).forEach(entry -> ((Advertiser)entry.getValue()).advertise(group, stream, level));
        return this;
    }

    public void remove(byte group) {
        this.advertisers.entrySet().stream().map(Map.Entry::getValue).forEach(advert -> advert.remove(group));
    }

    public void remove(byte group, String stream) {
        this.advertisers.entrySet().stream().map(Map.Entry::getValue).forEach(advert -> advert.remove(group, stream));
    }

    public void setConnected(boolean value) {
        this.advertisers.values().forEach(advertiser -> advertiser.setConnected(value));
    }
}

