/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.delivery;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jayeson.database.DatabaseManager;
import jayeson.lib.delivery.core.CommonDependencies;
import jayeson.lib.delivery.module.auth.AuthEntryConfig;
import jayeson.lib.delivery.module.auth.AuthModule;
import jayeson.lib.delivery.module.auth.AuthServiceConfig;
import jayeson.lib.delivery.module.streamregistry.DefaultStreamRegistryModule;
import jayeson.lib.delivery.module.streamregistry.StreamRegistryEntryConfig;
import jayeson.lib.streamfinder.StreamfinderModule;
import jayeson.service.delivery.Amalgamate;
import jayeson.service.delivery.DeliveryConfig;
import jayeson.service.delivery.ProcessorConfig;
import jayeson.service.delivery.PublisherPrivateModule;
import jayeson.service.delivery.ScopeConfig;
import jayeson.service.delivery.ScopeEntry;
import jayeson.service.delivery.ScopePersist;
import jayeson.service.delivery.SubscriberPrivateModule;
import jayeson.utility.JacksonConfig;
import jayeson.utility.JacksonConfigFormat;

public class DeliveryModule
extends AbstractModule {
    static final String CONFIG_FILENAME = "delivery.json";
    static final String CONFIG_VAR_NAME = "deliveryConfFile";
    DeliveryConfig config;
    List<Module> modules;

    public DeliveryModule() throws InstantiationException {
        this(DeliveryModule.searchForConfig(CONFIG_FILENAME, CONFIG_VAR_NAME));
    }

    public DeliveryModule(DeliveryConfig config) throws InstantiationException {
        if (config == null) {
            throw new IllegalArgumentException("Delivery config cannot be null");
        }
        this.config = config;
        this.modules = this.parseModules(config);
    }

    static DeliveryConfig searchForConfig(String confFilename, String confSysVar) {
        DeliveryConfig conf = (DeliveryConfig)JacksonConfig.readConfig((String)confFilename, (String)confSysVar, DeliveryConfig.class, (JacksonConfigFormat)JacksonConfigFormat.JSON);
        if (conf == null) {
            throw new RuntimeException("Cannot find delivery configuration!! Please check class path");
        }
        return conf;
    }

    protected void configure() {
        this.install((Module)new CommonDependencies());
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"ServiceId")).toInstance((Object)this.config.getServiceId());
        Map<String, AuthEntryConfig> authenticatorConfigs = this.config.getScopes().getScopes().entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((ScopeEntry)entry.getValue()).getAuthConfig()));
        this.config.getAuthServiceConfig().setAuthenticatorConfigs(authenticatorConfigs);
        this.bind(ScopeConfig.class).toInstance((Object)this.config.getScopes());
        Map<String, StreamRegistryEntryConfig> regConfigs = this.config.getScopes().getScopes().entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((ScopeEntry)entry.getValue()).getRegistryConfig()));
        Map<String, String> scopeToPersist = regConfigs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StreamRegistryEntryConfig)entry.getValue()).getPersistenceUnit()));
        this.bind(ScopePersist.class).toInstance((Object)new ScopePersist(scopeToPersist));
        this.bind(AuthServiceConfig.class).toInstance((Object)this.config.getAuthServiceConfig());
        this.bind(DatabaseManager.class).toInstance((Object)DatabaseManager.instance());
        this.install(new DefaultStreamRegistryModule());
        this.install((Module)new StreamfinderModule());
        this.install((Module)new PublisherPrivateModule(this.config.getPublisherConfig()));
        this.install((Module)new SubscriberPrivateModule(this.config.getSubscriberConfig()));
        this.install((Module)new AuthModule(this.config.getAuthServiceConfig()));
        this.modules.stream().forEach(arg_0 -> ((DeliveryModule)this).install(arg_0));
        this.bind(Amalgamate.class).asEagerSingleton();
    }

    List<Module> parseModules(DeliveryConfig config) throws InstantiationException {
        ArrayList<Module> pluginModules = new ArrayList<Module>();
        for (Map.Entry<Class<? extends Module>, ProcessorConfig> entry : config.getProcessors().entrySet()) {
            pluginModules.add(this.createModule(entry.getKey(), entry.getValue()));
        }
        return pluginModules;
    }

    Module createModule(Class<? extends Module> moduleType, ProcessorConfig config) throws InstantiationException {
        try {
            return moduleType.getConstructor(config.getClass()).newInstance(config);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new InstantiationException("Failed to construct " + moduleType + ". Cause: " + e.toString());
        }
    }
}

