/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.delivery;

import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;

class GroupPredicate
implements BiPredicate<Byte, String> {
    Byte group;
    Pattern searchTerms;

    public GroupPredicate(Map.Entry<Byte, List<String>> entry) {
        this.group = entry.getKey();
        String searchTerm = "^(" + String.join((CharSequence)"|", (Iterable<? extends CharSequence>)entry.getValue()) + ")$";
        this.searchTerms = Pattern.compile(searchTerm);
    }

    @Override
    public boolean test(Byte group, String stream) {
        return this.group.equals(group) && this.searchTerms.matcher(stream).matches();
    }
}

