/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.delivery;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.events.EPEvent;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.module.subscriber.ISubscriber;
import jayeson.lib.delivery.module.subscriber.StreamId;
import jayeson.lib.delivery.module.subscriber.events.ConsumptionErrorEvent;
import jayeson.lib.delivery.module.subscriber.events.ConsumptionStartEvent;
import jayeson.lib.streamfinder.Source;
import jayeson.service.delivery.AbstractProcessingEngine;
import jayeson.service.delivery.Downstream;
import jayeson.service.delivery.DownstreamCopy;
import jayeson.service.delivery.IInProcessor;
import jayeson.service.delivery.IOutProcessor;
import jayeson.service.delivery.Upstream;
import jayeson.service.delivery.UpstreamCopy;

public final class StreamCopyPe
extends AbstractProcessingEngine {
    Injector injector;
    final Class<? extends IMessageGroup> groupType;
    IMessageGroup group;
    Downstream downstreamProc;
    Upstream upstreamProc;
    Map<String, IEndPoint> upstreamSockets;

    public StreamCopyPe(Class<? extends IMessageGroup> groupType) {
        this.groupType = groupType;
        this.upstreamSockets = new HashMap<String, IEndPoint>();
    }

    @Override
    public void onStartUp() {
        ISubscriber sub = this.getSubscriber();
        sub.attachMessageGroupProcessor(this.getInProcessor());
        sub.attachListener(this::handleUpstreamAds);
        sub.attachListener(this::handleUpstreamSocket);
    }

    void handleUpstreamSocket(EPEvent event) {
        if (event instanceof ConsumptionStartEvent) {
            ConsumptionStartEvent startEvent = (ConsumptionStartEvent)event;
            Map<String, IEndPoint> providers = startEvent.getStreams().stream().filter(src -> src.group.byteValue() == this.group.id()).collect(Collectors.toMap(src -> src.stream, src -> event.getEndpoint()));
            this.upstreamSockets.putAll(providers);
        } else if (event instanceof ConsumptionErrorEvent) {
            ConsumptionErrorEvent stopEvent = (ConsumptionErrorEvent)event;
            Map<String, IEndPoint> providers = stopEvent.getStreams().stream().filter(src -> src.group.byteValue() == this.group.id()).collect(Collectors.toMap(src -> src.stream, src -> event.getEndpoint()));
            this.upstreamSockets.keySet().removeAll(providers.keySet());
        }
    }

    void handleUpstreamAds(EPEvent event) {
        if (event instanceof ConsumptionStartEvent) {
            ConsumptionStartEvent startEvent = (ConsumptionStartEvent)event;
            startEvent.getStreams().stream().forEach(this::advertiseStream);
        } else if (event instanceof ConsumptionErrorEvent) {
            ConsumptionErrorEvent stopEvent = (ConsumptionErrorEvent)event;
            stopEvent.getStreams().stream().forEach(s -> this.getAdvertiser().remove(s.group, s.stream));
        }
    }

    void advertiseStream(StreamId stream) {
        Optional<Source> fullSrc = this.getSubscriber().getStreams().stream().filter(src -> src.getGroup() == stream.group.byteValue() && src.getStreamName().equals(stream.stream)).findFirst();
        if (!fullSrc.isPresent()) {
            this.log.error("Unable to match level information for " + stream.group + " " + stream.stream);
            return;
        }
        this.getAdvertiser().advertise(stream.group, stream.stream, fullSrc.get().getLevel() + 1);
    }

    @Override
    protected boolean actOnStreamRegistrationRequest(IEndPoint ep, String stream) {
        return true;
    }

    @Override
    protected boolean actOnStreamDeRegistrationRequest(IEndPoint ep, String stream) {
        return true;
    }

    @Override
    protected void startPublishing(IEndPoint ep, String stream) {
        ISubscriber sub = this.getSubscriber();
        IEndPoint upSock = this.upstreamSockets.get(stream);
        ep.registerPreParsingHook(this.getMessageGroup(), new UpstreamCopy(sub, this.getMessageGroup(), stream, upSock));
    }

    @Override
    protected void actOnEndPointDiscontinued(IEndPoint ep) {
    }

    @Override
    public synchronized IMessageGroup getMessageGroup() {
        if (this.group == null) {
            this.group = (IMessageGroup)this.injector.getInstance(this.groupType);
        }
        return this.group;
    }

    @Override
    public synchronized IInProcessor getInProcessor() {
        if (this.upstreamProc == null) {
            DownstreamCopy downstreamCopier = new DownstreamCopy(this.getStreamRegistry(), this.getMessageGroup());
            this.upstreamProc = new Upstream(downstreamCopier, this.getMessageGroup());
        }
        return this.upstreamProc;
    }

    @Override
    public synchronized IOutProcessor getOutProcessor() {
        if (this.downstreamProc == null) {
            this.downstreamProc = new Downstream(this.getMessageGroup());
        }
        return this.downstreamProc;
    }

    @Inject
    public void setInjector(Injector injector) {
        this.injector = injector;
    }
}

