/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.client;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.IEndPointListener;
import jayeson.lib.delivery.api.events.EPEvent;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.module.subscriber.ISubscriber;
import jayeson.lib.delivery.module.subscriber.StreamId;
import jayeson.lib.delivery.module.subscriber.events.ConsumptionErrorEvent;
import jayeson.lib.delivery.module.subscriber.events.ConsumptionStartEvent;
import jayeson.lib.delivery.module.subscriber.events.ConsumptionStopEvent;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.sports.client.FeedView;
import jayeson.lib.sports.client.InternalDeltaEventHandler;
import jayeson.lib.sports.codec.FilterData;
import jayeson.lib.sports.receive.InEndPointEventHandler;
import jayeson.lib.sports.receive.SportsFeedInConfig;
import jayeson.lib.sports.receive.SportsFeedInProcessor;
import jayeson.model.IDataFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SportsFeedClient
implements InternalDeltaEventHandler<IBetMatch, IBetEvent, IBetRecord> {
    private static Logger log = LoggerFactory.getLogger(SportsFeedClient.class);
    private ISubscriber subscriber;
    private InEndPointEventHandler eventHandler;
    private SportsFeedInConfig config;
    private FeedView<IBetMatch> viewTemplate;
    private Set<FeedView<?>> createdViews;
    private Map<Integer, CompletableFuture<Boolean>> switchFilterResults;
    private Map<CompletableFuture<Boolean>, Set<Integer>> switchFilterIds;
    private ScheduledExecutorService executor;

    @Inject
    public SportsFeedClient(ISubscriber subscriber, SportsFeedInConfig config, FeedView<IBetMatch> viewTemplate, InEndPointEventHandler eventHandler, SportsFeedInProcessor inProcessor, ScheduledExecutorService executor) {
        this.subscriber = subscriber;
        this.config = config;
        this.viewTemplate = viewTemplate;
        this.attachDefaultListener();
        this.eventHandler = eventHandler;
        this.configureEventHandler(eventHandler);
        this.createdViews = Collections.synchronizedSet(new HashSet());
        this.viewTemplate.register(this);
        this.switchFilterResults = new ConcurrentHashMap<Integer, CompletableFuture<Boolean>>();
        this.switchFilterIds = new ConcurrentHashMap<CompletableFuture<Boolean>, Set<Integer>>();
        this.executor = executor;
        subscriber.attachMessageGroupProcessor((IMessageGroupProcessor)inProcessor);
        inProcessor.startTTlVerification(executor);
    }

    private void attachDefaultListener() {
        this.subscriber.attachListener(new IEndPointListener(){

            public void onEvent(EPEvent event) {
                SportsFeedClient.this.eventListener(event);
            }
        });
    }

    private void eventListener(EPEvent event) {
        if (event instanceof ConsumptionStartEvent) {
            ConsumptionStartEvent eve = (ConsumptionStartEvent)event;
            for (StreamId streamId : eve.getStreams()) {
                log.trace("ConsumptionStartEvent for streams {} from {} ", (Object)streamId.getIdentifier(), (Object)event.getEndpoint().getIdentifier());
            }
        } else if (event instanceof ConsumptionErrorEvent) {
            ConsumptionErrorEvent eve = (ConsumptionErrorEvent)event;
            for (StreamId streamId : eve.getStreams()) {
                log.error("ConsumptionErrorEvent for stream {} ", (Object)streamId.getIdentifier());
            }
        } else if (event instanceof ConsumptionStopEvent) {
            ConsumptionStopEvent eve = (ConsumptionStopEvent)event;
            for (StreamId streamId : eve.getStreams()) {
                log.trace("ConsumptionStopEvent for stream {} ", (Object)streamId.getIdentifier());
            }
        } else {
            log.trace("Received event {} from {}", (Object)event, (Object)event.getEndpoint().getIdentifier());
        }
    }

    private void configureEventHandler(InEndPointEventHandler eventHandler) {
        this.subscriber.attachListener((IEndPointListener)eventHandler);
        this.setUpStreamFilter(this.config.getFilterData(), true);
        if (this.config.isExcludeRateId()) {
            this.eventHandler.excludeRateId();
        }
    }

    public CompletableFuture<Boolean> setUpStreamFilter(FilterData filterData) {
        return this.setUpStreamFilter(filterData, this.eventHandler.getStreamSources().isEmpty());
    }

    public CompletableFuture<Boolean> setUpStreamFilter(FilterData filterData, boolean initialFilter) {
        if (initialFilter) {
            this.eventHandler.updateFilter(filterData, true);
            CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
            result.complete(true);
            return result;
        }
        Set<Integer> requestIds = this.eventHandler.updateFilter(filterData, false);
        CompletableFuture<Boolean> switchFilterResult = new CompletableFuture<Boolean>();
        for (Integer requestId : requestIds) {
            this.switchFilterResults.put(requestId, switchFilterResult);
        }
        this.switchFilterIds.put(switchFilterResult, requestIds);
        return switchFilterResult;
    }

    @Override
    public void onSwitchFilterFail(int requestId) {
        if (requestId != -1 && this.switchFilterResults.containsKey(requestId)) {
            CompletableFuture<Boolean> current = this.switchFilterResults.remove(requestId);
            current.complete(false);
            Set<Integer> requestIds = this.switchFilterIds.get(current);
            for (int existingId : requestIds) {
                this.switchFilterResults.remove(existingId);
            }
        }
    }

    @Override
    public void onSwitchFilterStart(int requestId) {
        if (requestId != -1 && this.switchFilterResults.containsKey(requestId)) {
            CompletableFuture<Boolean> current = this.switchFilterResults.remove(requestId);
            Set<Integer> requestIds = this.switchFilterIds.get(current);
            requestIds.remove(requestId);
            if (requestIds.isEmpty()) {
                current.complete(true);
                this.switchFilterIds.remove(current);
            }
        }
    }

    public ISubscriber getSubscriber() {
        return this.subscriber;
    }

    public void start() {
        this.getSubscriber().startConsuming();
    }

    public void stop() {
        this.getSubscriber().stopConsuming();
        this.executor.shutdown();
    }

    public <M extends IBetMatch> FeedView<M> view(Class<M> clazz) {
        return this.view(null, clazz);
    }

    public <M extends IBetMatch> FeedView<M> view(IDataFilter filter, Class<M> clazz) {
        FeedView<M> newView = new FeedView<M>(this.viewTemplate, filter, clazz);
        this.createdViews.add(newView);
        return newView;
    }

    public <M extends IBetMatch> void removeView(FeedView<M> view) {
        view.cleanUp();
        this.createdViews.remove(view);
    }

    public Map<CompletableFuture<Void>, IEndPoint> sendKeepAlive() {
        return this.sendKeepAlive(0L);
    }

    public Map<CompletableFuture<Void>, IEndPoint> sendKeepAlive(long timeOut) {
        return this.eventHandler.sendKeepAlive(timeOut);
    }
}

