/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.client;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jayeson.lib.delivery.api.SslConfig;
import jayeson.lib.delivery.module.subscriber.ScopedSubscriberConfig;
import jayeson.lib.delivery.module.subscriber.StandAloneSubscriberModule;
import jayeson.lib.delivery.module.subscriber.SubscriberConfig;
import jayeson.lib.sports.client.SportsConfig;
import jayeson.lib.sports.client.SportsFeedClient;
import jayeson.lib.sports.core.TTLConfig;
import jayeson.lib.sports.module.Module;
import jayeson.lib.sports.receive.SportsFeedInConfig;
import jayeson.lib.streamfinder.StreamfinderConfig;
import jayeson.utility.JacksonConfig;
import jayeson.utility.JacksonConfigFormat;

@Singleton
public class SportsFeedFactory {
    static final String CONFIG_FILENAME = "libSportConfig.json";

    public SportsFeedClient create() {
        return this.createFromConfigFile(CONFIG_FILENAME);
    }

    public SportsFeedClient createFromConfigFile(String filename) {
        return this.createFromConfig(SportsFeedFactory.searchForConfig(filename, null));
    }

    public SportsFeedClient createFromConfig(SportsConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Client config cannot be null");
        }
        return this.createFromSubscriberConf(SportsFeedFactory.convertSportsConfToSubscriberConf(config), SportsFeedFactory.convertSportsConfToSportsFeedConf(config));
    }

    private static String constructStreamWithFilters(SportsConfig in) {
        int count;
        StringBuilder constructStream = new StringBuilder();
        if (in.getSportFilter() != null) {
            if (in.getSportFilter().isEmpty()) {
                constructStream.append(".*");
            } else {
                count = 0;
                for (String sport : in.getSportFilter()) {
                    if (in.getSportFilter().size() > 1 && count == 0) {
                        constructStream.append("(" + sport + "|");
                    }
                    if (in.getSportFilter().size() > 1 && count + 1 < in.getSportFilter().size() && count > 0) {
                        constructStream.append(sport + "|");
                    }
                    if (in.getSportFilter().size() == 1) {
                        constructStream.append(sport);
                    }
                    if (in.getSportFilter().size() > 1 && count + 1 == in.getSportFilter().size()) {
                        constructStream.append(sport + ")");
                    }
                    ++count;
                }
            }
        } else {
            constructStream.append(".*");
        }
        if (in.getBookFilter() != null) {
            if (in.getBookFilter().isEmpty()) {
                if (in.getSportFilter() != null && !in.getSportFilter().isEmpty()) {
                    constructStream.append(".*");
                }
            } else {
                count = 0;
                for (String sportBook : in.getBookFilter()) {
                    if (in.getBookFilter().size() > 1 && count == 0) {
                        constructStream.append("_(" + sportBook + "|");
                    }
                    if (in.getBookFilter().size() > 1 && count + 1 < in.getBookFilter().size() && count > 0) {
                        constructStream.append(sportBook + "|");
                    }
                    if (in.getBookFilter().size() == 1) {
                        constructStream.append("_" + sportBook);
                    }
                    if (in.getBookFilter().size() > 1 && count + 1 == in.getBookFilter().size()) {
                        constructStream.append(sportBook + ")");
                    }
                    ++count;
                }
            }
        } else if (in.getSportFilter() != null && !in.getSportFilter().isEmpty()) {
            constructStream.append(".*");
        }
        if (in.getOddTypeFilter() != null) {
            if (in.getOddTypeFilter().isEmpty()) {
                if (in.getBookFilter() != null && !in.getBookFilter().isEmpty()) {
                    constructStream.append(".*");
                }
            } else {
                count = 0;
                for (String oddType : in.getOddTypeFilter()) {
                    if (in.getOddTypeFilter().size() > 1 && count == 0) {
                        constructStream.append("_(" + oddType + "|");
                    }
                    if (in.getOddTypeFilter().size() > 1 && count + 1 < in.getOddTypeFilter().size() && count > 0) {
                        constructStream.append(oddType + "|");
                    }
                    if (in.getOddTypeFilter().size() == 1) {
                        constructStream.append("_" + oddType);
                    }
                    if (in.getOddTypeFilter().size() > 1 && count + 1 == in.getOddTypeFilter().size()) {
                        constructStream.append(oddType + ")");
                    }
                    ++count;
                }
            }
        } else if (in.getBookFilter() != null && !in.getBookFilter().isEmpty()) {
            constructStream.append(".*");
        }
        return constructStream.toString();
    }

    static SubscriberConfig convertSportsConfToSubscriberConf(SportsConfig in) {
        SubscriberConfig subConfig = new SubscriberConfig();
        StreamfinderConfig sfConf = new StreamfinderConfig(in.getUsername(), in.getPassword(), in.getUri(), "");
        if (in.getScope() != null) {
            sfConf.setDiscoverByScope(true);
        }
        ScopedSubscriberConfig scopeFeed = new ScopedSubscriberConfig();
        List<String> streamList = Arrays.asList(SportsFeedFactory.constructStreamWithFilters(in));
        HashMap<String, List<String>> discMap = new HashMap<String, List<String>>();
        discMap.put("70", streamList);
        scopeFeed.setDiscoveryStreams(discMap);
        scopeFeed.setDiscoveryStreams(discMap);
        scopeFeed.setSfConfig(sfConf);
        subConfig.setAuthDataRenewIntervalMs(30000L);
        HashMap<String, ScopedSubscriberConfig> scopeMap = new HashMap<String, ScopedSubscriberConfig>();
        scopeMap.put(in.getScope(), scopeFeed);
        subConfig.setScopes(scopeMap);
        SslConfig sslConfig = new SslConfig();
        sslConfig.setEnableSelfSignedCert(true);
        subConfig.setSslConfig(sslConfig);
        return subConfig;
    }

    static SportsFeedInConfig convertSportsConfToSportsFeedConf(SportsConfig in) {
        SportsFeedInConfig sportsFeed = new SportsFeedInConfig();
        sportsFeed.setTtlConfig(in.getTtlConfig());
        sportsFeed.setExcludeRateId(in.getExcludeRateId());
        return sportsFeed;
    }

    static SportsConfig searchForConfig(String confFilename, String confSysVar) {
        SportsConfig conf = (SportsConfig)JacksonConfig.readConfig((String)confFilename, (String)confSysVar, SportsConfig.class, (JacksonConfigFormat)JacksonConfigFormat.JSON);
        if (conf == null) {
            throw new RuntimeException("Cannot find configuration!! Please check class path");
        }
        return conf;
    }

    public SportsFeedClient createFromSubscriberConf(SubscriberConfig subConfig, SportsFeedInConfig sportsConfig) {
        if (sportsConfig.getTtlConfig() == null) {
            TTLConfig ttlConfig = new TTLConfig();
            ttlConfig.setEnableTtl(true);
            ttlConfig.setEarlyttl(30000);
            ttlConfig.setTodayttl(15000);
            ttlConfig.setLivettl(5000);
            sportsConfig.setTtlConfig(ttlConfig);
        }
        StandAloneSubscriberModule subscriberModule = new StandAloneSubscriberModule(subConfig);
        Module.Client clientModule = new Module.Client(sportsConfig);
        Injector inj = Guice.createInjector((Module[])new Module[]{subscriberModule, clientModule});
        SportsFeedClient client = (SportsFeedClient)inj.getInstance(SportsFeedClient.class);
        return client;
    }
}

