/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.datastructure;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.feed.core.Snapshot;
import jayeson.lib.sports.datastructure.IndexedSnapshot;

public class IndexedSnapshotImpl
extends Snapshot<IBetMatch>
implements IndexedSnapshot {
    private final ImmutableMap<PartitionKey, Long> partitions;
    public static final IndexedSnapshotImpl EMPTY_SNAPSHOT = new IndexedSnapshotImpl();

    public IndexedSnapshotImpl() {
        this(new ArrayList<IBetMatch>());
    }

    public IndexedSnapshotImpl(Map<SportType, Collection<IBetMatch>> matches, Collection<PartitionKey> partitions) {
        this(matches, partitions.stream().collect(Collectors.toMap(Function.identity(), x -> System.currentTimeMillis())));
    }

    public IndexedSnapshotImpl(Map<String, IBetMatch> matchesByIds, Map<PartitionKey, Long> partitions, boolean createNewMatchIdMapping) {
        super(matchesByIds, createNewMatchIdMapping);
        this.partitions = ImmutableMap.copyOf(partitions);
    }

    public IndexedSnapshotImpl(Collection<IBetMatch> matches) {
        this(matches, new HashMap<PartitionKey, Long>());
    }

    public IndexedSnapshotImpl(Collection<IBetMatch> matches, Map<PartitionKey, Long> partitions) {
        super(matches);
        this.partitions = ImmutableMap.copyOf(partitions);
    }

    public IndexedSnapshotImpl(Map<SportType, Collection<IBetMatch>> matches, Map<PartitionKey, Long> keys) {
        super(matches);
        this.partitions = ImmutableMap.copyOf(keys);
    }

    @Override
    public Set<PartitionKey> getPartitions() {
        return this.partitions.keySet();
    }

    @Override
    public Map<PartitionKey, Long> getPartitionMap() {
        return this.partitions;
    }

    public Collection<IBetMatch> matches() {
        return super.matches();
    }

    public Collection<IBetMatch> matches(SportType type) {
        return super.matches(type);
    }

    public <T extends IBetMatch> Collection<T> matchesOfSport(SportType type) {
        return super.matchesOfSport(type);
    }

    public Collection<SportType> sports() {
        return super.sports();
    }
}

