/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch;

import java.util.Collection;
import java.util.function.Consumer;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.Outgoing;
import jayeson.lib.sports.dispatch.EPGCache;
import jayeson.lib.sports.dispatch.IDispatchableWrapper;
import jayeson.lib.sports.dispatch.IEndPointDispatcher;
import jayeson.lib.sports.dispatch.IEndPointGroup;
import jayeson.lib.sports.dispatch.WrapperImpl;
import jayeson.model.IDataFilter;

public class SwitchFilterSnapshotWrapper
extends WrapperImpl
implements IDispatchableWrapper {
    private IDataFilter oldFilter;
    private IndexedSnapshot fullSnapshot;
    private Collection<IEndPointDispatcher> epds;
    private IEndPointGroup newEPG;
    private EPGCache epgCache;
    private int requestId;

    public SwitchFilterSnapshotWrapper(IEndPointGroup oldEPG, IEndPointGroup newEPG, String stream, Collection<IEndPointDispatcher> epds, IDataFilter oldFilter, IndexedSnapshot fullSnapshot, EPGCache epgCache, int requestId) {
        super(oldEPG, stream);
        this.fullSnapshot = fullSnapshot;
        this.oldFilter = oldFilter;
        this.epds = epds;
        this.newEPG = newEPG;
        this.epgCache = epgCache;
        this.requestId = requestId;
    }

    @Override
    public Consumer<Void> process() {
        return Void2 -> {
            for (IEndPointDispatcher epd : this.epds) {
                epd.setOldEPG(null);
            }
            this.getEpg().submitForPostProcess(this);
        };
    }

    @Override
    public Consumer<Void> postProcess() {
        return Void2 -> {
            Collection<Outgoing> mws = this.newEPG.generate(this);
            if (mws != null) {
                for (Outgoing mw : mws) {
                    if (mw == null) continue;
                    this.epds.forEach(epd -> epd.submitToDispatchingQueue(mw));
                }
                this.epds.forEach(epd -> epd.submitEndQueueIndicatorToDispatchingQueue(true));
            }
            this.newEPG.setInitialized(true);
            this.epds.forEach(epd -> this.getEpg().removeEPD((IEndPointDispatcher)epd));
            this.epgCache.destroyEPG(this.getEpg());
        };
    }

    public IDataFilter getOldFilter() {
        return this.oldFilter;
    }

    public IndexedSnapshot getFullSnapshot() {
        return this.fullSnapshot;
    }

    public int getRequestId() {
        return this.requestId;
    }
}

