/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch.network;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.sports.codec.FilterRequest;
import jayeson.lib.sports.codec.StartSubscribeFeed;
import jayeson.lib.sports.dispatch.EPDispatcherException;
import jayeson.lib.sports.dispatch.IEndPointDispatcher;
import jayeson.lib.sports.dispatch.IEndPointGroupManager;
import jayeson.lib.sports.dispatch.network.AdminMsg;
import jayeson.lib.sports.dispatch.network.DistributedDispatcherfactory;
import jayeson.lib.sports.dispatch.network.SocketStream;
import jayeson.lib.sports.util.InjectLogger;
import jayeson.model.IDataFilter;
import org.slf4j.Logger;

@Singleton
public class FeedSubscriptions {
    final Map<SocketStream, AdminMsg> subscriptions = new ConcurrentHashMap<SocketStream, AdminMsg>();
    final IEndPointGroupManager epgm;
    final DistributedDispatcherfactory dispatcherFactory;
    @InjectLogger
    Logger log;

    @Inject
    public FeedSubscriptions(IEndPointGroupManager epgm, DistributedDispatcherfactory factory) {
        this.epgm = epgm;
        this.dispatcherFactory = factory;
    }

    public void add(IEndPoint socket, String stream) {
        this.subscriptions.put(new SocketStream(socket, stream), new AdminMsg());
    }

    public void remove(IEndPoint socket, String stream) throws EPDispatcherException {
        AdminMsg msg = this.subscriptions.remove(new SocketStream(socket, stream));
        if (msg != null && msg.getStartCmd() != null) {
            this.epgm.deregisterEPD(msg.getDispatcher());
        }
    }

    public void setFilter(IEndPoint socket, String stream, FilterRequest filterRequest) {
        AdminMsg msgs = this.subscriptions.get(new SocketStream(socket, stream));
        if (msgs == null) {
            this.log.error("Unable to add filter for " + socket.getIdentifier() + " " + stream + ". Unknown subscription");
            return;
        }
        IDataFilter filter = filterRequest.getFilterData() != null ? filterRequest.getFilterData().getFilter() : null;
        this.log.trace("Received Filter for {} {} {}", new Object[]{stream, socket.getIdentifier(), filter});
        msgs.setFilter(filter);
        if (msgs.getStartCmd() != null) {
            IEndPointDispatcher epd = msgs.getDispatcher();
            this.epgm.switchFilter(epd, filterRequest);
        }
    }

    public void start(IEndPoint socket, String stream, StartSubscribeFeed start) {
        AdminMsg msgs = this.subscriptions.get(new SocketStream(socket, stream));
        if (msgs == null) {
            this.log.error("Unable to start feed for " + socket.getIdentifier() + " " + stream + ". Unknown subscription");
            return;
        }
        if (msgs.getStartCmd() != null) {
            this.log.error(socket.getIdentifier() + " " + stream + " has already been started");
            return;
        }
        msgs.setStartCmd(start);
        IEndPointDispatcher epd = this.dispatcherFactory.createEPD(socket, stream);
        this.log.trace("Register EPD and Pushing FS for {} {}. Exclusion list {}", new Object[]{stream, socket.getIdentifier(), start.getExclude()});
        msgs.setDispatcher(epd);
        this.epgm.registerEPD(epd, msgs.getFilter());
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }
}

