/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch.transform;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.sports.core.SnapshotUtil;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.datastructure.DeltaOutgoing;
import jayeson.lib.sports.datastructure.DeltaOutgoingImpl;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.IndexedSnapshotImpl;
import jayeson.lib.sports.datastructure.Outgoing;
import jayeson.lib.sports.datastructure.OutgoingImpl;
import jayeson.lib.sports.dispatch.FullSnapshotWrapper;
import jayeson.lib.sports.dispatch.SwitchFilterSnapshotWrapper;
import jayeson.lib.sports.dispatch.TTLSnapshotWrapper;
import jayeson.lib.sports.dispatch.UpdateFilterSnapshotWrapper;
import jayeson.lib.sports.dispatch.transform.CacheTrackingLogic;
import jayeson.lib.sports.dispatch.transform.FilterProcessor;
import jayeson.lib.sports.dispatch.transform.FilteringEPG;
import jayeson.lib.sports.dispatch.transform.MessageEncoder;
import jayeson.lib.sports.filter.FilterableIndexSnapshot;
import jayeson.lib.sports.filter.FilterableOutgoing;
import jayeson.lib.sports.mutable.BuilderProvider;
import jayeson.lib.sports.mutable.IIndexedSnapshotBuilder;
import jayeson.model.IDataFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndPointGroupCommandProcessor {
    private String streamName;
    private FilterProcessor cache;
    private FilteringEPG grp;
    private MessageEncoder msgEncoder;
    private static Logger log = LoggerFactory.getLogger(EndPointGroupCommandProcessor.class);

    @Inject
    public EndPointGroupCommandProcessor(MessageEncoder msgEncoder, @Assisted FilteringEPG grp, @Assisted String streamName, CacheTrackingLogic ct) {
        this.streamName = streamName;
        this.grp = grp;
        this.msgEncoder = msgEncoder;
        this.cache = new FilterProcessor(grp.getSportsFeedGrp(), ct);
    }

    public IDataFilter getFilter() {
        return this.grp.getFilter();
    }

    SportsFeedMessageGroup getSportsFeedGrp() {
        return this.grp.getSportsFeedGrp();
    }

    public String getStreamName() {
        return this.streamName;
    }

    public Collection<Outgoing> serializeOutgoingMessages(Collection<Outgoing> messages) {
        ArrayList<Outgoing> result = new ArrayList<Outgoing>();
        for (Outgoing message : messages) {
            try {
                result.addAll(this.msgEncoder.encode(message, this.getSportsFeedGrp()));
            }
            catch (Exception exp) {
                log.error("Error serializing message", (Throwable)exp);
            }
        }
        return result;
    }

    protected IndexedSnapshot markOddPartitionsOnly(IndexedSnapshot snapshot) {
        IIndexedSnapshotBuilder snapshotBuilder = BuilderProvider.getSnapshotBuilder(snapshot, false);
        for (IBetMatch match : snapshot.matches()) {
            for (IBetEvent event : match.events()) {
                for (IBetRecord record : event.records()) {
                    snapshotBuilder.markPartitionAsUpdated(new PartitionKey(record.source(), record.oddType(), match.sportType()));
                }
            }
        }
        return (IndexedSnapshot)snapshotBuilder.build();
    }

    public Collection<Outgoing> processFullSnapshot(FullSnapshotWrapper wrapper) {
        try {
            FilterableIndexSnapshot filteredRecordsSnapshot = new FilterableIndexSnapshot(wrapper.getFullSnapshot(), this.getFilter());
            IndexedSnapshot filteredSnapshot = SnapshotUtil.constructFilteredSnapshot(filteredRecordsSnapshot);
            IndexedSnapshot oddSnapshot = this.markOddPartitionsOnly(filteredSnapshot);
            ArrayList<Outgoing> messages = new ArrayList<Outgoing>();
            messages.add(new OutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().FULLSNAPSHOT_START));
            messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_RESET, filteredSnapshot));
            messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_MATCH, filteredSnapshot));
            messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_EVENT, filteredSnapshot));
            List matchesList = Lists.partition(new ArrayList(oddSnapshot.matches()), (int)SnapshotUtil.SIZE_SPLIT_MATCH);
            for (List matches : matchesList) {
                IndexedSnapshotImpl delta = new IndexedSnapshotImpl(matches, oddSnapshot.getPartitionMap());
                messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_ODD, delta));
            }
            messages.add(new OutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().FULLSNAPSHOT_END));
            Collection<Outgoing> serializedMessages = this.serializeOutgoingMessages(messages);
            if (!this.cache.cacheTracker.isInitialized()) {
                this.cache.cacheAll(filteredSnapshot);
                this.cache.cacheTracker.setInitialized(true);
            }
            return serializedMessages;
        }
        catch (Exception exp) {
            log.error("Exception processing full snapshot", (Throwable)exp);
            return Arrays.asList(new Outgoing[0]);
        }
    }

    public Collection<Outgoing> processPartialSnapshot(DeltaOutgoing outGng) {
        try {
            FilterableOutgoing filtered = new FilterableOutgoing(outGng, this.getFilter());
            List<Outgoing> messages = this.cache.update(filtered);
            Collection<Outgoing> serializedMessages = this.serializeOutgoingMessages(messages);
            return serializedMessages;
        }
        catch (Exception exp) {
            log.error("Exception processing partial snapshot", (Throwable)exp);
            return Arrays.asList(new Outgoing[0]);
        }
    }

    public Collection<Outgoing> processTTLSnapshot(TTLSnapshotWrapper wrapper, boolean fullSnapshot) {
        try {
            FilterableIndexSnapshot filteredRecordsSnapshot = new FilterableIndexSnapshot(wrapper.getRestoredSnapshot(), this.getFilter());
            FilterableIndexSnapshot filteredMatchEventSnapshot = new FilterableIndexSnapshot(wrapper.getFullSnapshot(), this.getFilter());
            IndexedSnapshot filteredSnapshot = SnapshotUtil.constructFilteredSnapshot(new IndexedSnapshotImpl(filteredMatchEventSnapshot.matches(), filteredMatchEventSnapshot.getPartitionMap()));
            ArrayList<Outgoing> messages = new ArrayList<Outgoing>();
            if (fullSnapshot) {
                messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().TTL_RESTORE_START, new IndexedSnapshotImpl(new HashMap<SportType, Collection<IBetMatch>>(), filteredRecordsSnapshot.getPartitions())));
                messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_MATCH, filteredSnapshot));
                messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_EVENT, filteredSnapshot));
                messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_ODD, filteredRecordsSnapshot, null, filteredRecordsSnapshot));
                messages.add(new OutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().TTL_RESTORE_END));
            } else {
                messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().TTL_RESTORE, new IndexedSnapshotImpl(new HashMap<SportType, Collection<IBetMatch>>(), wrapper.getFullSnapshot().getPartitions())));
            }
            Collection<Outgoing> serializedMessages = this.serializeOutgoingMessages(messages);
            return serializedMessages;
        }
        catch (Exception exp) {
            log.error("Exception processing TTL snapshot", (Throwable)exp);
            return Arrays.asList(new Outgoing[0]);
        }
    }

    public Collection<Outgoing> processSwitchFilterSnapshot(SwitchFilterSnapshotWrapper wrapper) {
        try {
            IDataFilter oldFilter = wrapper.getOldFilter();
            SnapshotUtil._DiffResult result = SnapshotUtil.getDiffSnapshots(wrapper.getFullSnapshot(), oldFilter, this.getFilter(), this.getSportsFeedGrp());
            if (!this.cache.cacheTracker.isInitialized()) {
                this.cache.cacheAll(result.fullSnapshot);
                this.cache.cacheTracker.setInitialized(true);
            }
            LinkedList<Outgoing> messages = new LinkedList<Outgoing>(result.messages);
            messages.add(0, new OutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().SWITCH_FILTER_START, wrapper.getRequestId()));
            messages.add(new OutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().SWITCH_FILTER_END));
            Collection<Outgoing> serializedMessages = this.serializeOutgoingMessages(messages);
            return serializedMessages;
        }
        catch (Exception exp) {
            log.error("Exception processing switch filter snapshot", (Throwable)exp);
            return Arrays.asList(new Outgoing[0]);
        }
    }

    public Collection<Outgoing> processUpdateFilterSnapshot(UpdateFilterSnapshotWrapper wrapper) {
        try {
            IDataFilter oldFilter = wrapper.getOldFilter();
            SnapshotUtil._DiffResult result = SnapshotUtil.getDiffSnapshots(wrapper.getFullSnapshot(), oldFilter, this.getFilter(), this.getSportsFeedGrp());
            this.cache.reset();
            this.cache.cacheAll(result.fullSnapshot);
            this.cache.cacheTracker.setInitialized(true);
            LinkedList<Outgoing> messages = new LinkedList<Outgoing>(result.messages);
            messages.add(0, new OutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().SWITCH_FILTER_START, -1));
            messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().SWITCH_FILTER_END, null));
            Collection<Outgoing> serializedMessages = this.serializeOutgoingMessages(messages);
            return serializedMessages;
        }
        catch (Exception exp) {
            log.error("Exception processing update filter snapshot", (Throwable)exp);
            return Arrays.asList(new Outgoing[0]);
        }
    }
}

