/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.receive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.sports.core.Delta;
import jayeson.lib.sports.core.DeltaTransformingLogic;
import jayeson.lib.sports.core.RecycleBin;
import jayeson.lib.sports.core.SnapshotUtil;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.datastructure.ConvertedMsg;
import jayeson.lib.sports.datastructure.DeltaOutgoing;
import jayeson.lib.sports.datastructure.Incoming;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.IndexedSnapshotImpl;
import jayeson.lib.sports.datastructure.MergeableWrapper;
import jayeson.lib.sports.datastructure.MessageBeforeTransform;
import jayeson.lib.sports.datastructure.TTLWrapper;

public class MergeableIncoming
extends Incoming
implements Function<IndexedSnapshot, MergeableWrapper> {
    private SportsFeedMessageGroup sportsGrp;
    private DeltaTransformingLogic transformingLogic;
    private IndexedSnapshot beforeSnap;
    private RecycleBin bin;

    public MergeableIncoming(SportsFeedMessageGroup sportsGrp, IMessageClass<?> snapshotType, String streamName, IndexedSnapshot data, DeltaTransformingLogic transformingLogic, RecycleBin bin) {
        super(snapshotType, streamName, data);
        this.sportsGrp = sportsGrp;
        this.transformingLogic = transformingLogic;
        this.bin = bin;
    }

    @Override
    public MergeableWrapper apply(IndexedSnapshot before) {
        if (before == null) {
            before = IndexedSnapshotImpl.EMPTY_SNAPSHOT;
        }
        ArrayList<DeltaOutgoing> outgoCol = new ArrayList<DeltaOutgoing>();
        this.beforeSnap = before;
        MergeableWrapper wrap = new MergeableWrapper();
        if (this.msgType().isSameFormat((IMessageClass)this.sportsGrp.DATA_INSERT_MATCH) || this.msgType().isSameFormat((IMessageClass)this.sportsGrp.DATA_INSERT_EVENT) || this.msgType().isSameFormat((IMessageClass)this.sportsGrp.DATA_DELETE_MATCH) || this.msgType().isSameFormat((IMessageClass)this.sportsGrp.DATA_DELETE_EVENT) || this.msgType().isSameFormat((IMessageClass)this.sportsGrp.DATA_UPDATE_EVENT)) {
            MessageBeforeTransform msgBefore = SnapshotUtil.combineSnapshots(this.msgType(), this.data(), before);
            Collection<Incoming> incomeCol = this.transformingLogic.transform(this.sportsGrp, this.stream(), this.msgType(), this.data(), msgBefore);
            incomeCol.stream().forEach(i -> {
                Delta iDelta = !i.getConverted().equals((Object)ConvertedMsg.ORIGINAL) ? new Delta((Incoming)i, msgBefore.getAfterSs(), this.beforeSnap, i.getConverted()) : new Delta((Incoming)i, msgBefore.getAfterSs(), this.beforeSnap);
                outgoCol.add(iDelta);
                this.beforeSnap = msgBefore.getAfterSs();
            });
            wrap.setDeltaOut(outgoCol);
            wrap.setAfter(msgBefore.getAfterSs());
        } else if (this.msgType().isSameFormat((IMessageClass)this.sportsGrp.TTL_REMOVE)) {
            IndexedSnapshot snapshot = before;
            HashMap<PartitionKey, Long> keysRemoved = new HashMap<PartitionKey, Long>();
            ArrayList<IndexedSnapshot> ttlRemoveList = new ArrayList<IndexedSnapshot>();
            boolean atleastOneKeyRemoved = false;
            Map<PartitionKey, Long> allKeys = before.getPartitionMap();
            for (PartitionKey key : this.data().getPartitions()) {
                if (!allKeys.containsKey(key)) continue;
                atleastOneKeyRemoved = true;
                keysRemoved.put(key, allKeys.get(key));
                TTLWrapper ttlWrapper = this.bin.removeData(new TTLWrapper(), snapshot, key);
                snapshot = ttlWrapper.getRemainingSs();
                ttlRemoveList.add(ttlWrapper.getRemovedSs());
            }
            if (atleastOneKeyRemoved) {
                wrap = this.transformingLogic.transformTTLRemove(ttlRemoveList, this.bin.getGrp(), this.stream(), before, snapshot, keysRemoved);
            } else {
                wrap.setDeltaOut(outgoCol);
                wrap.setAfter(before);
            }
        } else if (this.msgType().isSameFormat((IMessageClass)this.sportsGrp.TTL_RESTORE)) {
            IndexedSnapshot snapshot = before;
            boolean atleastOneKeyRestored = false;
            HashMap<PartitionKey, Long> restoredKeys = new HashMap<PartitionKey, Long>();
            ArrayList<TTLWrapper> ttlRestoredList = new ArrayList<TTLWrapper>();
            for (PartitionKey key : this.data().getPartitions()) {
                if (!this.bin.containData(key)) continue;
                atleastOneKeyRestored = true;
                long restoreTime = System.currentTimeMillis();
                restoredKeys.put(key, restoreTime);
                TTLWrapper ttlWrapper = this.bin.restoreData(snapshot, key, restoreTime);
                snapshot = ttlWrapper.getRemainingSs();
                ttlRestoredList.add(ttlWrapper);
            }
            if (atleastOneKeyRestored) {
                wrap = this.transformingLogic.transformTTLRestore(ttlRestoredList, this.bin.getGrp(), this.stream(), before, snapshot, restoredKeys);
            } else {
                wrap.setDeltaOut(outgoCol);
                wrap.setAfter(before);
            }
        } else {
            MessageBeforeTransform msgBefore = SnapshotUtil.combineSnapshots(this.msgType(), this.data(), before);
            Delta iDelta = new Delta(this, msgBefore.getAfterSs(), before);
            outgoCol.add(iDelta);
            wrap.setDeltaOut(outgoCol);
            wrap.setAfter(msgBefore.getAfterSs());
        }
        return wrap;
    }
}

