/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.datastructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jayeson.lib.datastructure.MetaRecord;
import jayeson.lib.datastructure.MetaRecordImpl;
import jayeson.lib.datastructure.Record;
import jayeson.lib.datastructure.SoccerEvent;
import jayeson.lib.datastructure.SoccerEventLiveState;

public abstract class BasicSoccerEvent
implements Cloneable,
SoccerEvent {
    private String eventId;
    private String league;
    private String host;
    private String guest;
    private SoccerEventLiveState liveState = null;
    protected HashMap<String, SoccerEventLiveState> liveStateMap;
    protected Map<String, String> oeids = new HashMap<String, String>();
    protected long createdTime = System.currentTimeMillis();

    public BasicSoccerEvent() {
        this.liveStateMap = new HashMap();
    }

    @Override
    public Collection<SoccerEventLiveState> getAllLiveState() {
        ArrayList<SoccerEventLiveState> liveStateList = new ArrayList<SoccerEventLiveState>();
        liveStateList.addAll(this.liveStateMap.values());
        return liveStateList;
    }

    @Override
    public SoccerEventLiveState getLiveState(String source) {
        return this.liveStateMap.get(source);
    }

    protected void updateLiveStateMap(SoccerEventLiveState liveState) {
        this.liveStateMap.put(liveState.getSource(), liveState);
    }

    @Override
    public SoccerEvent clone() {
        return null;
    }

    @Override
    public String getEventId() {
        return this.eventId;
    }

    @Override
    public String getLeague() {
        return this.league;
    }

    protected void setLeague(String league) {
        this.league = league;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    protected void setHost(String host) {
        this.host = host;
    }

    protected void setEventId(String eventId) {
        this.eventId = eventId;
    }

    @Override
    public String getGuest() {
        return this.guest;
    }

    protected void setGuest(String guest) {
        this.guest = guest;
    }

    @Override
    public SoccerEventLiveState getLiveState() {
        return this.liveState;
    }

    protected void setLiveState(SoccerEventLiveState liveState) {
        this.liveState = liveState;
    }

    protected void setOriginalEventId(String book, String oeid) {
        this.oeids.put(book, oeid);
    }

    @Override
    public String getOriginalEventId(String book) {
        return this.oeids.get(book);
    }

    @Override
    public Map<String, String> getAllOriginalEventIds() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(this.oeids);
        return map;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public MetaRecord getMetaRecord(Record r) {
        MetaRecordImpl imp = new MetaRecordImpl(this, r);
        return imp;
    }
}

