/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.datastructure;

import jayeson.lib.datastructure.AbstractMetaRecord;
import jayeson.lib.datastructure.LBType;
import jayeson.lib.datastructure.MetaRecord;
import jayeson.lib.datastructure.OddType;
import jayeson.lib.datastructure.PivotBias;
import jayeson.lib.datastructure.PivotType;
import jayeson.lib.datastructure.Record;
import jayeson.lib.datastructure.SoccerEvent;
import jayeson.lib.datastructure.SoccerEventLiveState;
import jayeson.lib.datastructure.TimeType;

public class MetaRecordImpl
extends AbstractMetaRecord {
    private SoccerEvent event;
    private Record record;

    public MetaRecordImpl(SoccerEvent event, Record record) {
        this.event = event;
        this.record = record;
    }

    @Override
    public String getSource() {
        return this.record.getSource();
    }

    @Override
    public int getOddId() {
        return this.record.getOddId();
    }

    @Override
    public String getEventId() {
        return this.record.getEventId();
    }

    @Override
    public long getCreateTime() {
        return this.record.getCreatedTime();
    }

    @Override
    public OddType getOddType() {
        return this.record.getOddType();
    }

    @Override
    public PivotBias getPivotBias() {
        return this.record.getPivotBias();
    }

    @Override
    public PivotType getPivotType() {
        return this.record.getPivotType();
    }

    @Override
    public TimeType getTimeType() {
        return this.record.getTimeType();
    }

    @Override
    public String getPivotValue() {
        return this.record.pivotString;
    }

    @Override
    public float getRateOver() {
        return this.record.getRateOver();
    }

    @Override
    public float getRateUnder() {
        return this.record.getRateUnder();
    }

    @Override
    public float getRateEqual() {
        return this.record.getRateEqual();
    }

    @Override
    public String getRateOverUid() {
        return this.record.getRateOverUid();
    }

    @Override
    public String getRateUnderUid() {
        return this.record.getRateUnderUid();
    }

    @Override
    public String getRateEqualUid() {
        return this.record.getRateEqualUid();
    }

    @Override
    public String getLeague() {
        return this.event.getLeague();
    }

    @Override
    public String getHost() {
        return this.event.getHost();
    }

    @Override
    public String getGuest() {
        return this.event.getGuest();
    }

    @Override
    public MetaRecord deepCopy() {
        MetaRecordImpl copy = new MetaRecordImpl(this.event, this.record);
        copy.setInitialHdpFT(this._initialHdpFT);
        copy.setInitialOuFT(this._initialOuFT);
        copy.setInitialHdpSpreadFT(this._initialHdpSpreadFT);
        copy.setInitialOuSpreadFT(this._initialOuSpreadFT);
        copy.setInitialHdpHT(this.getInitialHdpHT());
        copy.setInitialOuHT(this.getInitialOuHT());
        copy.setInitialHdpSpreadHT(this.getInitialHdpSpreadHT());
        copy.setInitialOuSpreadHT(this.getInitialOuSpreadHT());
        return copy;
    }

    @Override
    public SoccerEventLiveState getLiveState() {
        return this.event.getLiveState();
    }

    @Override
    public float getPivotInFloat() {
        return this.record.getPivotValue();
    }

    @Override
    public String getOriginalEventID() {
        return this.event.getAllOriginalEventIds().get(this.record.getSource());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Market = ").append((Object)this.record.oddType).append(";");
        builder.append("EventMinorCategory = ").append((Object)this.record.timeType).append(";");
        builder.append("EventUid = ").append(this.record.eventId).append(";");
        builder.append("PivotType = ").append((Object)this.record.pivotType).append(";");
        builder.append("PivotValue = ").append(this.record.pivotValue).append(";");
        builder.append("Source = ").append(this.record.source).append(";");
        builder.append("EventStatus = ").append(this.event.getLiveState().toString()).append(";");
        return builder.toString();
    }

    @Override
    public boolean isTeamSwapped() {
        return this.record.isTeamSwapped();
    }

    @Override
    public LBType getLBType() {
        return this.record.getLBType();
    }

    @Override
    public long getLastRefreshTime() {
        return this.record.getLastRefreshTime();
    }
}

