/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.datastructure;

import java.util.HashMap;
import java.util.Map;
import jayeson.lib.datastructure.ResultState;

public class ResultEvent {
    private String eventId;
    private String league;
    private String host;
    private String guest;
    private Map<String, ResultState> resultStateMap = new HashMap<String, ResultState>();
    private long updatedTime;

    public ResultEvent() {
        this.setUpdatedTime(-1L);
    }

    public ResultEvent clone() {
        ResultEvent resultEvent = new ResultEvent();
        resultEvent.setEventId(this.eventId);
        resultEvent.setLeague(this.league);
        resultEvent.setHost(this.host);
        resultEvent.setGuest(this.guest);
        for (Map.Entry<String, ResultState> entry : this.resultStateMap.entrySet()) {
            resultEvent.setResultState(entry.getKey(), entry.getValue().clone());
        }
        resultEvent.setUpdatedTime(this.updatedTime);
        return resultEvent;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getLeague() {
        return this.league;
    }

    public void setLeague(String league) {
        this.league = league;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getGuest() {
        return this.guest;
    }

    public void setGuest(String guest) {
        this.guest = guest;
    }

    public long getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(long updatedTime) {
        this.updatedTime = updatedTime;
    }

    public ResultState getResultState(String source) {
        return this.resultStateMap.get(source);
    }

    public void setResultState(String source, ResultState resultState) {
        this.resultStateMap.put(source, resultState);
    }

    public Map<String, ResultState> getResultStateMap() {
        return this.resultStateMap;
    }
}

