/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.feed.api;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.lang.reflect.Method;
import jayeson.lib.feed.api.EnumInterface;
import jayeson.lib.feed.api.EventTypeDeserializer;
import jayeson.lib.feed.api.SportType;

@JsonDeserialize(using=EventTypeDeserializer.class)
public interface EventType
extends EnumInterface {
    public static final ObjectMapper mapper = new ObjectMapper();

    @JsonGetter(value="sportType")
    public SportType sportType();

    @Override
    @JsonGetter(value="name")
    public String name();

    public static <T extends EventType> String serialize(T eventType) throws JsonProcessingException {
        return mapper.writeValueAsString(eventType);
    }

    public static EventType deserialize(String value) throws IOException {
        return (EventType)mapper.readValue(value, EventType.class);
    }

    public static EventType deserialize(JsonNode node) throws IOException {
        return (EventType)mapper.treeToValue((TreeNode)node, EventType.class);
    }

    public static EventType fromName(SportType sportType, String name) {
        try {
            Method method = sportType.eventTypeClass.getMethod("valueOf", String.class);
            return (EventType)method.invoke(null, name);
        }
        catch (Exception exp) {
            throw new IllegalArgumentException("Unable to create EventType from sportType: " + sportType.name() + " and name: " + name, exp);
        }
    }
}

