/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.feed.api;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.lang.reflect.Method;
import jayeson.lib.feed.api.EnumInterface;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.feed.api.TimeTypeDeserializer;

@JsonDeserialize(using=TimeTypeDeserializer.class)
public interface TimeType
extends EnumInterface {
    public static final ObjectMapper mapper = new ObjectMapper();

    @JsonGetter(value="sportType")
    public SportType sportType();

    @Override
    @JsonGetter(value="name")
    public String name();

    public static <T extends TimeType> String serialize(T timeType) throws JsonProcessingException {
        return mapper.writeValueAsString(timeType);
    }

    public static TimeType deserialize(String value) throws IOException {
        return (TimeType)mapper.readValue(value, TimeType.class);
    }

    public static TimeType deserialize(JsonNode node) throws IOException {
        return (TimeType)mapper.treeToValue((TreeNode)node, TimeType.class);
    }

    public static TimeType fromName(SportType sportType, String name) {
        try {
            Method method = sportType.timeTypeClass.getMethod("valueOf", String.class);
            return (TimeType)method.invoke(null, name);
        }
        catch (Exception exp) {
            throw new IllegalArgumentException("Unable to create TimeType from sportType: " + sportType.name() + " and name: " + name, exp);
        }
    }
}

