/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.feed.api.twoside;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.LBType;
import jayeson.lib.feed.api.OddType;
import jayeson.lib.feed.api.TimeType;
import jayeson.lib.feed.api.twoside.IB2EventState;
import jayeson.lib.feed.api.twoside.IB2Record;
import jayeson.lib.feed.api.twoside.PivotType;

public interface IB2Event
extends IBetEvent {
    default public Collection<? extends IB2Record> records(PivotType pivotType) {
        return this.records().stream().filter(r -> r.pivotType().equals((Object)pivotType)).collect(Collectors.toList());
    }

    default public boolean hasPivotType(PivotType pivotType) {
        return this.records().stream().anyMatch(r -> r.pivotType().equals((Object)pivotType));
    }

    public Collection<? extends IB2Record> records();

    default public Collection<? extends IB2Record> records(TimeType timeType) {
        return IBetEvent.super.records(timeType);
    }

    @Override
    default public IB2Record record(String source, long id) {
        return (IB2Record)IBetEvent.super.record(source, id);
    }

    default public Collection<? extends IB2Record> getRecords(String bookId) {
        return IBetEvent.super.getRecords(bookId);
    }

    default public Collection<? extends IB2Record> getRecords(String bookId, TimeType timeType) {
        return IBetEvent.super.getRecords(bookId, timeType);
    }

    default public Collection<? extends IB2Record> getRecords(String bookId, OddType oddType) {
        return IBetEvent.super.getRecords(bookId, oddType);
    }

    default public Collection<? extends IB2Record> getRecords(String bookId, LBType lbType) {
        return IBetEvent.super.getRecords(bookId, lbType);
    }

    default public Collection<? extends IB2Record> getRecords(List<String> bookIdList, LBType lbType) {
        return IBetEvent.super.getRecords(bookIdList, lbType);
    }

    @Override
    public IB2EventState eventState();

    public Collection<? extends IB2EventState> eventStates();
}

