/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.feed.basketball;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jayeson.lib.feed.api.IParticipantStats;

public class BasketballStats
implements IParticipantStats {
    private int totalScore;
    private int hasQuarterScore;
    private List<Integer> fullScore;
    private List<Integer> scoreList;

    public BasketballStats(int totalScore, int hasQuarterScore, int firstQuarterScore, int secondQuarterScore, int thirdQuarterScore, int fourthQuarterScore, int overtimeScore) {
        this.totalScore = totalScore;
        this.fullScore = new ArrayList<Integer>();
        this.hasQuarterScore = hasQuarterScore;
        this.fullScore.addAll(Arrays.asList(firstQuarterScore, secondQuarterScore, thirdQuarterScore, fourthQuarterScore, overtimeScore));
        if (totalScore == -1) {
            this.scoreList = new ArrayList<Integer>();
        } else {
            this.setScores(firstQuarterScore, secondQuarterScore, thirdQuarterScore, fourthQuarterScore, overtimeScore);
        }
    }

    @Override
    public List<Integer> getScores() {
        return this.scoreList;
    }

    public BasketballStats(List<Integer> scoreList) {
        if (scoreList.size() != 0) {
            this.totalScore = scoreList.get(0);
            this.hasQuarterScore = scoreList.get(1);
            this.fullScore = new ArrayList<Integer>();
            if (scoreList.size() > 2) {
                for (int i = 2; i < scoreList.size(); ++i) {
                    this.fullScore.add(scoreList.get(i));
                }
            }
            if (scoreList.size() == 2) {
                this.setScores(-1, -1, -1, -1, -1);
            } else if (scoreList.size() == 3) {
                this.setScores(scoreList.get(2), -1, -1, -1, -1);
            } else if (scoreList.size() == 4) {
                this.setScores(scoreList.get(2), scoreList.get(3), -1, -1, -1);
            } else if (scoreList.size() == 5) {
                this.setScores(scoreList.get(2), scoreList.get(3), scoreList.get(4), -1, -1);
            } else if (scoreList.size() == 6) {
                this.setScores(scoreList.get(2), scoreList.get(3), scoreList.get(4), scoreList.get(5), -1);
            } else {
                this.setScores(scoreList.get(2), scoreList.get(3), scoreList.get(4), scoreList.get(5), scoreList.get(6));
            }
        } else {
            this.scoreList = new ArrayList<Integer>();
            this.fullScore = new ArrayList<Integer>();
            this.hasQuarterScore = 1;
            this.totalScore = -1;
        }
    }

    private void setScores(int firstQuarterScore, int secondQuarterScore, int thirdQuarterScore, int fourthQuarterScore, int overtimeScore) {
        this.scoreList = firstQuarterScore == -1 ? Arrays.asList(this.totalScore, this.hasQuarterScore) : (secondQuarterScore == -1 ? Arrays.asList(this.totalScore, this.hasQuarterScore, firstQuarterScore) : (thirdQuarterScore == -1 ? (overtimeScore == -1 ? Arrays.asList(this.totalScore, this.hasQuarterScore, firstQuarterScore, secondQuarterScore) : Arrays.asList(this.totalScore, this.hasQuarterScore, firstQuarterScore, secondQuarterScore, overtimeScore)) : (fourthQuarterScore == -1 ? Arrays.asList(this.totalScore, this.hasQuarterScore, firstQuarterScore, secondQuarterScore, thirdQuarterScore) : (overtimeScore == -1 ? Arrays.asList(this.totalScore, this.hasQuarterScore, firstQuarterScore, secondQuarterScore, thirdQuarterScore, fourthQuarterScore) : Arrays.asList(this.totalScore, this.hasQuarterScore, firstQuarterScore, secondQuarterScore, thirdQuarterScore, fourthQuarterScore, overtimeScore)))));
    }

    public int getQuarterScore(int quarterNum) {
        if (this.fullScore.size() < quarterNum || quarterNum < 0 || this.hasQuarterScore == 0) {
            return -1;
        }
        return this.fullScore.get(quarterNum - 1);
    }

    public int getHalfScore(int segmentNum) {
        if (this.fullScore.size() < segmentNum || segmentNum < 0 || this.hasQuarterScore == 1) {
            return -1;
        }
        return this.fullScore.get(segmentNum - 1);
    }

    public boolean hasQuarterScore() {
        return this.hasQuarterScore == 1;
    }

    public int getTotalScore() {
        return this.totalScore;
    }
}

