/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.feed.core;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import jayeson.lib.feed.api.LBType;
import jayeson.lib.feed.api.OddFormat;
import jayeson.lib.feed.api.OddType;
import jayeson.lib.feed.api.TimeType;
import jayeson.lib.feed.api.twoside.IB2Record;
import jayeson.lib.feed.api.twoside.PivotBias;
import jayeson.lib.feed.api.twoside.PivotType;
import jayeson.lib.feed.core.BetRecord;

public class B2Record
extends BetRecord
implements IB2Record {
    private final float rateOver;
    private final float rateUnder;
    private final float rateEqual;
    private final float pivotValue;
    private final PivotType pivotType;
    private final PivotBias pivotBias;
    private final String rateOverId;
    private final String rateUnderId;
    private final String rateEqualId;
    private final boolean isSwapped;

    public B2Record(String matchId, String eventId, long id, OddType oddType, LBType lbType, TimeType timetype, String sportbook, OddFormat oddFormat, Map<String, String> meta, float rateOver, float rateUnder, float rateEqual, float pivotValue, PivotType pivotType, PivotBias pivotBias, String rateOverId, String rateUnderId, String rateEqualId, boolean isSwapped) {
        super(matchId, eventId, id, oddType, lbType, timetype, sportbook, oddFormat, meta);
        this.rateOver = rateOver;
        this.rateUnder = rateUnder;
        this.rateEqual = rateEqual;
        this.pivotValue = pivotValue;
        this.pivotType = pivotType;
        this.pivotBias = pivotBias;
        this.rateOverId = rateOverId;
        this.rateUnderId = rateUnderId;
        this.rateEqualId = rateEqualId;
        this.isSwapped = isSwapped;
    }

    @Override
    public float pivotValue() {
        return this.pivotValue;
    }

    @Override
    public PivotType pivotType() {
        return this.pivotType;
    }

    @Override
    public PivotBias pivotBias() {
        return this.pivotBias;
    }

    @Override
    public boolean isSwapped() {
        return this.isSwapped;
    }

    @Override
    public float rateOver() {
        return this.rateOver;
    }

    @Override
    public float rateUnder() {
        return this.rateUnder;
    }

    @Override
    public float rateEqual() {
        return this.rateEqual;
    }

    @Override
    public String rateOverId() {
        return this.rateOverId;
    }

    @Override
    public String rateUnderId() {
        return this.rateUnderId;
    }

    @Override
    public String rateEqualId() {
        return this.rateEqualId;
    }

    @Override
    public List<Float> rates() {
        return Arrays.asList(Float.valueOf(this.rateOver), Float.valueOf(this.rateUnder), Float.valueOf(this.rateEqual));
    }

    @Override
    public List<String> rateIds() {
        return Arrays.asList(this.rateOverId, this.rateUnderId, this.rateEqualId);
    }
}

