/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.feed.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.lib.feed.api.SportType;

public class Snapshot<M extends IBetMatch>
implements ISnapshot<M> {
    private Map<SportType, Collection<M>> matchesBySport;
    private final Map<String, M> matchesById;

    public Snapshot(Collection<M> matches) {
        this.matchesById = new HashMap<String, M>();
        matches.forEach(match -> this.matchesById.put(match.id(), match));
    }

    public Snapshot(Map<String, M> matches, boolean createNewMap) {
        if (createNewMap) {
            this.matchesById = new HashMap<String, M>();
            this.matchesById.putAll(matches);
        } else {
            this.matchesById = matches;
        }
    }

    public Snapshot(Map<SportType, Collection<M>> matchesBySport) {
        this.matchesBySport = matchesBySport;
        this.matchesById = new HashMap<String, M>();
        matchesBySport.values().forEach(matches -> matches.forEach(match -> this.matchesById.put(match.id(), match)));
    }

    @Override
    public Collection<M> matches() {
        return this.matchesById.values();
    }

    public Map<SportType, Collection<M>> matchesBySport() {
        if (this.matchesBySport == null) {
            this.matchesBySport = ISnapshot.matchesBySport(this.matchesById.values());
        }
        return this.matchesBySport;
    }

    @Override
    public Collection<M> matches(SportType type) {
        Collection<M> sportMatches = this.matchesBySport().get(type);
        if (sportMatches == null) {
            return Collections.emptyList();
        }
        return sportMatches;
    }

    @Override
    public <T extends M> Collection<T> matchesOfSport(SportType type) {
        Collection<M> sportMatch = this.matches(type);
        return sportMatch;
    }

    @Override
    public Collection<SportType> sports() {
        return this.matchesBySport().keySet();
    }

    @Override
    public boolean hasMatch(String matchId) {
        return this.matchesById.containsKey(matchId);
    }

    @Override
    public M match(String matchId) {
        return (M)((IBetMatch)this.matchesById.get(matchId));
    }
}

