/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.record;

import jayeson.lib.record.EventSegment;

public class EventStatus {
    public EventSegment segment;
    public int duration;
    public String startTime;
    public int hostPoint;
    public int guestPoint;
    public int hostExpelled;
    public int guestExpelled;

    public EventStatus deepCopy() {
        EventStatus s = new EventStatus();
        s.segment = this.segment;
        s.duration = this.duration;
        s.startTime = this.startTime;
        s.hostPoint = this.hostPoint;
        s.guestPoint = this.guestPoint;
        s.hostExpelled = this.hostExpelled;
        s.guestExpelled = this.guestExpelled;
        return s;
    }

    public String toDisplayStr() {
        String statusText = null;
        switch (this.segment) {
            case PENDING: {
                statusText = "Pending";
                break;
            }
            case FIRST_HALF: 
            case SECOND_HALF: 
            case EXTRA_FIRST_HALF: 
            case EXTRA_SECOND_HALF: {
                statusText = String.format("%d' %d-%d <%d %d>", this.duration, this.hostPoint, this.guestPoint, this.hostExpelled, this.guestExpelled);
                break;
            }
            case HALF_BREAK: {
                statusText = String.format("HT %d-%d <%d %d>", this.hostPoint, this.guestPoint, this.hostExpelled, this.guestExpelled);
                break;
            }
            case FULL_BREAK: {
                statusText = String.format("FT %d-%d <%d %d>", this.hostPoint, this.guestPoint, this.hostExpelled, this.guestExpelled);
                break;
            }
            case EXTRA_HALF_BREAK: {
                statusText = String.format("Ex. %d-%d <%d %d>", this.hostPoint, this.guestPoint, this.hostExpelled, this.guestExpelled);
                break;
            }
            case PENALTY: {
                statusText = String.format("Pen %d-%d <%d %d>", this.hostPoint, this.guestPoint, this.hostExpelled, this.guestExpelled);
                break;
            }
            case FINISHED: {
                statusText = String.format("End %d-%d <%d %d>", this.hostPoint, this.guestPoint, this.hostExpelled, this.guestExpelled);
                break;
            }
            default: {
                statusText = "End";
            }
        }
        return statusText;
    }
}

