/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.datastructure;

import jayeson.lib.datastructure.MetaRecord;
import jayeson.lib.datastructure.PivotBias;
import jayeson.lib.datastructure.PivotType;
import jayeson.lib.datastructure.RateLine;
import jayeson.lib.datastructure.TargetType;

public abstract class AbstractMetaRecord
implements MetaRecord {
    public static float INVALID_HDP_VALUE = Float.MAX_VALUE;
    public static float INVALID_OU_VALUE = Float.MAX_VALUE;
    public static final float INVALID_SPREAD_VALUE = Float.MAX_VALUE;
    protected float _initialHdpFT;
    protected float _initialOuFT;
    protected float _initialHdpSpreadFT = INVALID_HDP_VALUE;
    protected float _initialOuSpreadFT = Float.MAX_VALUE;
    protected float _initialHdpHT;
    protected float _initialOuHT;
    protected float _initialHdpSpreadHT;
    protected float _initialOuSpreadHT;
    protected long _metaRecordCreatedTime;
    protected long _expireTime;

    public AbstractMetaRecord() {
        this._initialOuFT = INVALID_OU_VALUE;
        this._initialHdpFT = INVALID_HDP_VALUE;
        this._initialHdpSpreadHT = INVALID_HDP_VALUE;
        this._initialOuSpreadHT = Float.MAX_VALUE;
        this._initialOuHT = INVALID_OU_VALUE;
        this._initialHdpHT = INVALID_HDP_VALUE;
        this._metaRecordCreatedTime = System.currentTimeMillis();
    }

    @Override
    public float getInitialHdpFT() {
        return this._initialHdpFT;
    }

    @Override
    public void setInitialHdpFT(float initialHdpFT) {
        this._initialHdpFT = initialHdpFT;
    }

    @Override
    public boolean hasInitialHdpFT() {
        return this._initialHdpFT != INVALID_HDP_VALUE;
    }

    @Override
    public float getInitialOuFT() {
        return this._initialOuFT;
    }

    @Override
    public void setInitialOuFT(float initialOuFT) {
        this._initialOuFT = initialOuFT;
    }

    @Override
    public boolean hasInitialOuFT() {
        return this._initialOuFT != INVALID_OU_VALUE;
    }

    @Override
    public float getInitialHdpSpreadFT() {
        return this._initialHdpSpreadFT;
    }

    @Override
    public void setInitialHdpSpreadFT(float initialHdpSpreadFT) {
        this._initialHdpSpreadFT = initialHdpSpreadFT;
    }

    @Override
    public boolean hasInitialHdpSpreadFT() {
        return this._initialHdpSpreadFT != Float.MAX_VALUE;
    }

    @Override
    public float getInitialOuSpreadFT() {
        return this._initialOuSpreadFT;
    }

    @Override
    public void setInitialOuSpreadFT(float initialOuSpreadFT) {
        this._initialOuSpreadFT = initialOuSpreadFT;
    }

    @Override
    public boolean hasInitialOuSpreadFT() {
        return this._initialOuSpreadFT != Float.MAX_VALUE;
    }

    @Override
    public float getInitialHdpHT() {
        return this._initialHdpHT;
    }

    @Override
    public void setInitialHdpHT(float initialHdpHT) {
        this._initialHdpHT = initialHdpHT;
    }

    @Override
    public boolean hasInitialHdpHT() {
        return this._initialHdpHT != INVALID_HDP_VALUE;
    }

    @Override
    public float getInitialOuHT() {
        return this._initialOuHT;
    }

    @Override
    public void setInitialOuHT(float initialOuHT) {
        this._initialOuHT = initialOuHT;
    }

    @Override
    public boolean hasInitialOuHT() {
        return this._initialOuHT != INVALID_OU_VALUE;
    }

    @Override
    public float getInitialHdpSpreadHT() {
        return this._initialHdpSpreadHT;
    }

    @Override
    public void setInitialHdpSpreadHT(float initialHdpSpreadHT) {
        this._initialHdpSpreadHT = initialHdpSpreadHT;
    }

    @Override
    public boolean hasInitialHdpSpreadHT() {
        return this._initialHdpSpreadHT != Float.MAX_VALUE;
    }

    @Override
    public float getInitialOuSpreadHT() {
        return this._initialOuSpreadHT;
    }

    @Override
    public void setInitialOuSpreadHT(float initialOuSpreadHT) {
        this._initialOuSpreadHT = initialOuSpreadHT;
    }

    @Override
    public boolean hasInitialOuSpreadHT() {
        return this._initialOuSpreadHT != Float.MAX_VALUE;
    }

    @Override
    public long getMetaRecordCreatedTime() {
        return this._metaRecordCreatedTime;
    }

    @Override
    public long getExpireTime() {
        return this._expireTime;
    }

    @Override
    public void setExpireTime(long expireTime) {
        this._expireTime = expireTime;
    }

    @Override
    public abstract MetaRecord deepCopy();

    @Override
    public RateLine getRateLine(TargetType target) {
        switch (target) {
            case OVER_FT: 
            case OVER_HT: {
                if (this.getPivotType() != PivotType.TOTAL) {
                    return RateLine.NONE;
                }
                return RateLine.OVER_LINE;
            }
            case ONE_FT: 
            case ONE_HT: {
                if (this.getPivotType() != PivotType.ONE_TWO) {
                    return RateLine.NONE;
                }
                return RateLine.OVER_LINE;
            }
            case UNDER_FT: 
            case UNDER_HT: {
                if (this.getPivotType() != PivotType.TOTAL) {
                    return RateLine.NONE;
                }
                return RateLine.UNDER_LINE;
            }
            case TWO_FT: 
            case TWO_HT: {
                if (this.getPivotType() != PivotType.ONE_TWO) {
                    return RateLine.NONE;
                }
                return RateLine.UNDER_LINE;
            }
            case GIVE_FT: 
            case GIVE_HT: {
                if (this.getPivotType() != PivotType.HDP) {
                    return RateLine.NONE;
                }
                if (this.getPivotBias() == PivotBias.HOST) {
                    return RateLine.OVER_LINE;
                }
                if (this.getPivotBias() == PivotBias.GUEST) {
                    return RateLine.UNDER_LINE;
                }
                if (this.getPivotBias() == PivotBias.NEUTRAL) {
                    if (this.getRateOver() > this.getRateUnder()) {
                        return RateLine.UNDER_LINE;
                    }
                    return RateLine.OVER_LINE;
                }
            }
            case TAKE_FT: 
            case TAKE_HT: {
                if (this.getPivotType() != PivotType.HDP) {
                    return RateLine.NONE;
                }
                if (this.getPivotBias() == PivotBias.HOST) {
                    return RateLine.UNDER_LINE;
                }
                if (this.getPivotBias() == PivotBias.GUEST) {
                    return RateLine.OVER_LINE;
                }
                if (this.getPivotBias() == PivotBias.NEUTRAL) {
                    if (this.getRateOver() > this.getRateUnder()) {
                        return RateLine.OVER_LINE;
                    }
                    return RateLine.UNDER_LINE;
                }
            }
            case HOME_FT: 
            case HOME_HT: {
                if (this.getPivotType() != PivotType.HDP) {
                    return RateLine.NONE;
                }
                return RateLine.OVER_LINE;
            }
            case AWAY_FT: 
            case AWAY_HT: {
                if (this.getPivotType() != PivotType.HDP) {
                    return RateLine.NONE;
                }
                return RateLine.UNDER_LINE;
            }
            case DRAW_FT: 
            case DRAW_HT: {
                if (this.getPivotType() != PivotType.ONE_TWO) {
                    return RateLine.NONE;
                }
                return RateLine.EQUAL_LINE;
            }
        }
        return RateLine.NONE;
    }

    @Override
    public float getTargetRate(TargetType target) {
        switch (this.getRateLine(target)) {
            case OVER_LINE: {
                return this.getRateOver();
            }
            case UNDER_LINE: {
                return this.getRateUnder();
            }
            case EQUAL_LINE: {
                return this.getRateEqual();
            }
            case NONE: {
                return -1000.0f;
            }
        }
        return -1000.0f;
    }

    @Override
    public float getOppositeTargetRate(TargetType target) {
        switch (this.getRateLine(target)) {
            case OVER_LINE: {
                return this.getRateUnder();
            }
            case UNDER_LINE: {
                return this.getRateOver();
            }
            case EQUAL_LINE: {
                return this.getRateEqual();
            }
            case NONE: {
                return -1000.0f;
            }
        }
        return -1000.0f;
    }

    @Override
    public String getTargetUid(TargetType target) {
        switch (this.getRateLine(target)) {
            case OVER_LINE: {
                return this.getRateOverUid();
            }
            case UNDER_LINE: {
                return this.getRateUnderUid();
            }
            case EQUAL_LINE: {
                return this.getRateEqualUid();
            }
            case NONE: {
                return "";
            }
        }
        return "";
    }

    @Override
    public String getTeamFromTarget(TargetType target) {
        switch (this.getRateLine(target)) {
            case OVER_LINE: {
                if (this.isTeamSwapped() && target.pivotType() != PivotType.TOTAL) {
                    return "away";
                }
                return "home";
            }
            case UNDER_LINE: {
                if (this.isTeamSwapped() && target.pivotType() != PivotType.TOTAL) {
                    return "home";
                }
                return "away";
            }
            case EQUAL_LINE: {
                return "draw";
            }
            case NONE: {
                return "";
            }
        }
        return "";
    }

    @Override
    public boolean hasSpread() {
        return this.getPivotType() == PivotType.HDP || this.getPivotType() == PivotType.TOTAL;
    }

    @Override
    public float getSpread() {
        float spread = 0.0f;
        spread = this.getRateOver() >= 1.0f && this.getRateUnder() < 1.0f ? -1.0f / this.getRateOver() + this.getRateUnder() : (this.getRateOver() < 1.0f && this.getRateUnder() >= 1.0f ? this.getRateOver() - 1.0f / this.getRateUnder() : (this.getRateOver() < 1.0f && this.getRateUnder() < 1.0f ? this.getRateOver() + this.getRateUnder() - 2.0f : Float.MAX_VALUE));
        return Math.abs(spread);
    }
}

