/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.datastructure;

import jayeson.lib.datastructure.EventSegment;
import jayeson.lib.datastructure.OddType;
import jayeson.lib.datastructure.SpecialEventCategory;

public class SoccerEventLiveState
implements Cloneable {
    protected int hostPoint;
    protected int guestPoint;
    protected int hostRedcard;
    protected int guestRedcard;
    protected SpecialEventCategory specialEventCategory;
    protected EventSegment segment;
    protected int duration;
    protected long startTime;
    protected String source;
    protected OddType marketType;
    protected long updatedTime = -1L;

    public int getHostPoint() {
        return this.hostPoint;
    }

    public int getGuestPoint() {
        return this.guestPoint;
    }

    public int getHostRedcard() {
        return this.hostRedcard;
    }

    public int getGuestRedcard() {
        return this.guestRedcard;
    }

    public SpecialEventCategory getSpecialEventCategory() {
        return this.specialEventCategory;
    }

    public EventSegment getSegment() {
        return this.segment;
    }

    public int getDuration() {
        return this.duration;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getSource() {
        return this.source;
    }

    public OddType getMarketType() {
        return this.marketType;
    }

    public boolean isExpired(long liveStateExpireInterval) {
        return System.currentTimeMillis() - this.updatedTime > liveStateExpireInterval;
    }

    protected long getUpdatedTime() {
        return this.updatedTime;
    }

    protected void setUpdatedTime(long value) {
        this.updatedTime = value;
    }

    public String toDisplayStr() {
        String statusText = null;
        switch (this.segment) {
            case PENDING: {
                statusText = "Pending";
                break;
            }
            case FIRST_HALF: 
            case SECOND_HALF: 
            case EXTRA_FIRST_HALF: 
            case EXTRA_SECOND_HALF: {
                statusText = String.format("%d' %d-%d <%d %d>", this.duration, this.hostPoint, this.guestPoint, this.hostRedcard, this.guestRedcard);
                break;
            }
            case HALF_BREAK: {
                statusText = String.format("HT %d-%d <%d %d>", this.hostPoint, this.guestPoint, this.hostRedcard, this.guestRedcard);
                break;
            }
            case FULL_BREAK: {
                statusText = String.format("FT %d-%d <%d %d>", this.hostPoint, this.guestPoint, this.hostRedcard, this.guestRedcard);
                break;
            }
            case EXTRA_HALF_BREAK: {
                statusText = String.format("Ex. %d-%d <%d %d>", this.hostPoint, this.guestPoint, this.hostRedcard, this.guestRedcard);
                break;
            }
            case PENALTY: {
                statusText = String.format("Pen %d-%d <%d %d>", this.hostPoint, this.guestPoint, this.hostRedcard, this.guestRedcard);
                break;
            }
            case FINISHED: {
                statusText = String.format("End %d-%d <%d %d>", this.hostPoint, this.guestPoint, this.hostRedcard, this.guestRedcard);
                break;
            }
            default: {
                statusText = "End";
            }
        }
        return statusText;
    }
}

