/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.datastructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jayeson.lib.datastructure.Record;
import jayeson.lib.datastructure.Snapshot;
import jayeson.lib.datastructure.SoccerEvent;
import jayeson.lib.datastructure.SportType;

public class SoccerSnapshot
implements Snapshot<SoccerEvent, Record> {
    private Map<String, SoccerEvent> events;

    public SoccerSnapshot() {
        this.events = new HashMap<String, SoccerEvent>();
    }

    public SoccerSnapshot(Collection<SoccerEvent> events) {
        this();
        for (SoccerEvent e : events) {
            this.events.put(e.getEventId(), e);
        }
    }

    public SoccerSnapshot(Map<String, SoccerEvent> events) {
        this.events = events;
    }

    @Override
    public Collection<Record> getAllRecords() {
        ArrayList<Record> records = new ArrayList<Record>();
        for (SoccerEvent event : this.events.values()) {
            records.addAll(event.getRecords());
        }
        return records;
    }

    @Override
    public Map<String, SoccerEvent> getAllEvents() {
        return this.events;
    }

    @Override
    public SoccerEvent getEventById(String eventId) {
        return this.events.get(eventId);
    }

    @Override
    public SportType getSportType() {
        return SportType.SOCCER;
    }
}

