/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.feed.api;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import jayeson.lib.feed.api.Attributable;
import jayeson.lib.feed.api.EventType;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.SportType;

public interface IBetMatch
extends Attributable {
    public List<String> participants();

    public long startTime();

    public Collection<? extends IBetEvent> events();

    default public Collection<? extends IBetEvent> events(EventType type) {
        return this.events().stream().filter(ev -> ev.eventType().equals(type)).collect(Collectors.toList());
    }

    public String id();

    public String league();

    public SportType sportType();

    public String getCountry();

    default public boolean hasEvent(String eventId) {
        for (IBetEvent iBetEvent : this.events()) {
            if (!iBetEvent.id().equals(eventId)) continue;
            return true;
        }
        return false;
    }

    default public IBetEvent event(String eventId) {
        for (IBetEvent iBetEvent : this.events()) {
            if (!iBetEvent.id().equals(eventId)) continue;
            return iBetEvent;
        }
        return null;
    }
}

