/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.feed.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.SportType;

public abstract class BetMatch
implements IBetMatch {
    private final long startTime;
    protected final Collection<? extends IBetEvent> events;
    private final String id;
    private final String league;
    private final SportType sport;
    private final Map<String, String> meta;

    public BetMatch(long startTime, Collection<? extends IBetEvent> events, String id, String league, SportType sport, Map<String, String> meta) {
        this.startTime = startTime;
        this.events = events;
        this.id = id;
        this.league = league;
        this.sport = sport;
        this.meta = meta;
    }

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String league() {
        return this.league;
    }

    @Override
    public SportType sportType() {
        return this.sport;
    }

    @Override
    public Collection<? extends IBetEvent> events() {
        return Collections.unmodifiableCollection(this.events);
    }

    @Override
    public Map<String, String> meta() {
        return this.meta;
    }

    @Override
    public String getCountry() {
        throw new UnsupportedOperationException();
    }
}

