/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.feed.tennis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jayeson.lib.feed.api.IParticipantStats;
import jayeson.lib.feed.tennis.ScoreType;

public class TennisStats
implements IParticipantStats {
    private int gameScore;
    private int setScore;
    private int point;
    private int isAv;
    private List<Integer> fullScore;
    private List<Integer> scoreList;
    private ScoreType scoreType;

    public TennisStats(int setScore, int gameScore, int point, int isAv, int firstSetGames, int secondSetGames, int thirdSetGames, int forthSetGames, int fifthSetGames, ScoreType scoreType) {
        this.gameScore = gameScore;
        this.setScore = setScore;
        this.point = point;
        this.isAv = isAv;
        this.scoreType = scoreType;
        this.fullScore = new ArrayList<Integer>();
        this.fullScore.addAll(Arrays.asList(firstSetGames, secondSetGames, thirdSetGames, forthSetGames, fifthSetGames));
        if (setScore == -1) {
            this.scoreList = new ArrayList<Integer>();
        } else {
            this.setScores(firstSetGames, secondSetGames, thirdSetGames, forthSetGames, fifthSetGames);
        }
    }

    public TennisStats(List<Integer> scoreList) {
        if (scoreList.size() != 0) {
            this.setScore = scoreList.get(0);
            this.gameScore = scoreList.get(1);
            this.point = scoreList.get(2);
            this.isAv = scoreList.get(3);
            this.scoreType = ScoreType.values()[scoreList.get(4)];
            this.fullScore = new ArrayList<Integer>();
            if (scoreList.size() > 5) {
                for (int i = 5; i < scoreList.size(); ++i) {
                    this.fullScore.add(scoreList.get(i));
                }
            } else {
                this.fullScore = new ArrayList<Integer>();
            }
            if (scoreList.size() == 5) {
                this.setScores(-1, -1, -1, -1, -1);
            } else if (scoreList.size() == 6) {
                this.setScores(scoreList.get(5), -1, -1, -1, -1);
            } else if (scoreList.size() == 7) {
                this.setScores(scoreList.get(5), scoreList.get(6), -1, -1, -1);
            } else if (scoreList.size() == 8) {
                this.setScores(scoreList.get(5), scoreList.get(6), scoreList.get(7), -1, -1);
            } else if (scoreList.size() == 9) {
                this.setScores(scoreList.get(5), scoreList.get(6), scoreList.get(7), scoreList.get(8), -1);
            } else if (scoreList.size() == 10) {
                this.setScores(scoreList.get(5), scoreList.get(6), scoreList.get(7), scoreList.get(8), scoreList.get(9));
            }
        } else {
            this.scoreList = new ArrayList<Integer>();
            this.fullScore = new ArrayList<Integer>();
            this.setScore = -1;
            this.gameScore = -1;
            this.point = -1;
            this.isAv = 0;
            this.scoreType = ScoreType.GAME_POINT;
        }
    }

    private void setScores(int firstSetGames, int secondSetGames, int thirdSetGames, int forthSetGames, int fifthSetGames) {
        this.scoreList = firstSetGames == -1 ? Arrays.asList(this.setScore, this.gameScore, this.point, this.isAv, this.scoreType.ordinal()) : (secondSetGames == -1 ? Arrays.asList(this.setScore, this.gameScore, this.point, this.isAv, this.scoreType.ordinal(), firstSetGames) : (thirdSetGames == -1 ? Arrays.asList(this.setScore, this.gameScore, this.point, this.isAv, this.scoreType.ordinal(), firstSetGames, secondSetGames) : (forthSetGames == -1 ? Arrays.asList(this.setScore, this.gameScore, this.point, this.isAv, this.scoreType.ordinal(), firstSetGames, secondSetGames, thirdSetGames) : (fifthSetGames == -1 ? Arrays.asList(this.setScore, this.gameScore, this.point, this.isAv, this.scoreType.ordinal(), firstSetGames, secondSetGames, thirdSetGames, forthSetGames) : Arrays.asList(this.setScore, this.gameScore, this.point, this.isAv, this.scoreType.ordinal(), firstSetGames, secondSetGames, thirdSetGames, forthSetGames, fifthSetGames)))));
    }

    @Override
    public List<Integer> getScores() {
        return this.scoreList;
    }

    public boolean getAv() {
        return this.isAv == 1;
    }

    public int getCurrentGameWon() {
        return this.gameScore;
    }

    public int getCurrentSetWon() {
        return this.setScore;
    }

    public int getCurrentPointWon() {
        return this.point;
    }

    public int getGameWon(int setNum) {
        if (this.fullScore.size() < setNum || setNum < 0) {
            return -1;
        }
        return this.fullScore.get(setNum - 1);
    }

    public ScoreType getScoreType() {
        return this.scoreType;
    }
}

