/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.api;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.Map;
import jayeson.lib.delivery.api.CoreComponent;
import jayeson.lib.delivery.api.NamedHandler;
import jayeson.lib.delivery.api.exceptions.GroupProcessorException;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.api.messages.IPreParsingHook;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.tasks.ResponseFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IRouter
extends CoreComponent {
    public static final Logger log = LoggerFactory.getLogger(IRouter.class);

    public IRouter registerProcessor(IMessageGroup var1, IMessageGroupProcessor var2);

    public IRouter registerPreParsingHook(IMessageGroup var1, IPreParsingHook var2);

    public IRouter deregisterPreParsingHook(byte var1);

    public Map<IMessageGroup, IMessageGroupProcessor> getRegisteredMessageGroups();

    public Map<IMessageGroup, IPreParsingHook> getRegisteredPreParsingHooks();

    @Override
    default public void attach(ChannelPipeline pipeline) {
        ChannelHandler transportRouterMarker = pipeline.get("TRANSPORT_ROUTER_MARKER");
        if (transportRouterMarker == null) {
            log.error("No {} in the pipeline. No action taken", (Object)"TRANSPORT_ROUTER_MARKER");
            return;
        }
        List<NamedHandler> routerHandlers = this.getDefaultHandlers();
        int length = routerHandlers.size();
        for (int i = length - 1; i >= 0; --i) {
            NamedHandler namedHandler = routerHandlers.get(i);
            log.trace("Adding {} {} AFTER {}", new Object[]{namedHandler.getName(), namedHandler.getClass(), "TRANSPORT_ROUTER_MARKER"});
            pipeline.addAfter("TRANSPORT_ROUTER_MARKER", namedHandler.getName(), (ChannelHandler)namedHandler);
        }
    }

    default public void dispatchMessage(MessageWrapper msgWrapper, IMessageGroupProcessor groupProcessor) throws Exception {
        msgWrapper.setEndpoint(this.getEndPoint());
        if (groupProcessor == null) {
            log.error("No GroupProcessor for Group {} , Class {} , Endpoint {}", new Object[]{msgWrapper.getMessageGroup().getClass(), msgWrapper.getMessageClass(), this.getEndPoint().getIdentifier()});
        } else {
            try {
                groupProcessor.process(msgWrapper);
            }
            catch (Exception ex) {
                GroupProcessorException gpx = new GroupProcessorException(ex);
                gpx.setPayLoad(msgWrapper);
                throw gpx;
            }
        }
    }

    public ResponseFuture storeRequest(MessageWrapper var1, long var2) throws Exception;

    public ResponseFuture clearRequest(String var1);

    public void rejectTimeoutRequests(long var1, boolean var3);

    public MessageWrapper createReply(MessageWrapper var1, MessageWrapper var2) throws Exception;

    public EventExecutor executor();
}

